/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.stat;

import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;

public class MakeTheStats {
    long maxCount = 100000L;
    String testDir = "Q:\\Stories\\";
    String currenFile = "test/stats/france24-en-133283d0a868d132b831ad1e064dd245.story.xml";
    RSSParser parser = new RSSParser();
    int problem = 0;
    Stack<Iterator<File>> stack = null;
    long count = 0L;

    public static void main(String[] args) {
        try {
            new MakeTheStats().make();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void make() throws Exception {
        Connection conn = this.getConnection();
        try {
            String file = null;
            PreparedStatement stat = conn.prepareStatement("INSERT INTO geostats(ngram, before, guid) VALUES (?, ?, ?) ");
            while ((file = this.getNextFile()) != null) {
                conn.createStatement().execute("begin");
                try {
                    this.analyzeFile(file, stat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                conn.createStatement().execute("commit");
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeFile(String file, PreparedStatement stat) throws Exception {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
        try {
            RSS rss = this.parser.parse((Reader)reader);
            for (RSSItem item : rss.getItems()) {
                this.analyzeItem(item, stat);
            }
        }
        finally {
            reader.close();
        }
    }

    private void analyzeItem(RSSItem item, PreparedStatement stat) throws SQLException {
        ArrayList georsses = item.getElements("emm:georss");
        stat.setString(3, item.getGuid());
        if (georsses != null) {
            for (SimpleElement georss : georsses) {
                for (String thispos : georss.getAttributeValue("wordpos").split(",")) {
                    int wordpos = Integer.parseInt(thispos);
                    String text = item.getTitle() + ". " + item.getDescription();
                    text = text.replaceAll("\\.$", "");
                    text = text.replaceAll("([0-9])[\\.\\,\\;\\:]", "$1");
                    text = text.replaceAll("(\\s)[\\.\\,\\;\\:]", "$1");
                    text = text.replaceAll("[\\.\\,\\;\\:-](\\s)", "$1");
                    if ((wordpos = this.guessPosition(wordpos, text = text.replaceAll("\\\u2014", " "), georss.getValue())) <= -1) continue;
                    String word = this.getWordAt(wordpos - 1, text);
                    String word2 = this.getWordAt(wordpos - 2, text);
                    if (word != null) {
                        stat.setBoolean(2, true);
                        stat.setString(1, word);
                        stat.executeUpdate();
                        if (word2 != null) {
                            stat.setBoolean(2, true);
                            stat.setString(1, word2 + " " + word);
                            stat.executeUpdate();
                        }
                    }
                    word = this.getWordAt(wordpos + 1, text);
                    word2 = this.getWordAt(wordpos + 2, text);
                    if (word == null) continue;
                    stat.setBoolean(2, false);
                    stat.setString(1, word);
                    stat.executeUpdate();
                    if (word2 == null) continue;
                    stat.setBoolean(2, false);
                    stat.setString(1, word + " " + word2);
                    stat.executeUpdate();
                }
            }
        }
    }

    private int guessPosition(int wordpos, String text, String value) {
        String found = this.getWordAt(wordpos, text);
        if (value.equals(found)) {
            return wordpos;
        }
        if (value.equals(this.getWordAt(wordpos + 1, text))) {
            return wordpos + 1;
        }
        if (value.equals(this.getWordAt(wordpos - 1, text))) {
            return wordpos - 1;
        }
        if (value.equals(this.getWordAt(wordpos + 2, text))) {
            return wordpos + 2;
        }
        if (value.equals(this.getWordAt(wordpos - 2, text))) {
            return wordpos - 2;
        }
        if (value.equals(this.getWordAt(wordpos + 3, text))) {
            return wordpos + 3;
        }
        if (value.equals(this.getWordAt(wordpos - 3, text))) {
            return wordpos - 3;
        }
        return -1;
    }

    private String getWordAt(int wordpos, String text) {
        return this.getWordAt(wordpos, text, false);
    }

    private String getWordAt(int i, String text, boolean debug) {
        try {
            Object[] split = text.split("[\\s]+");
            if (debug) {
                System.out.println("\t\tReturning : '" + split[i] + "'  " + Arrays.toString(split));
                System.out.println("\t\t\"" + text + "\"");
            }
            return split[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (i < 0) {
                // empty if block
            }
            return null;
        }
    }

    private String getNextFile() {
        if (this.stack == null) {
            this.stack = new Stack();
            File[] files = new File(this.testDir).listFiles();
            Arrays.sort(files, Collections.reverseOrder());
            Iterator<File> iter = Arrays.asList(files).iterator();
            this.stack.push(iter);
        }
        return this.returnFile();
    }

    private String returnFile() {
        if (this.stack.peek().hasNext()) {
            File file = this.stack.peek().next();
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                Arrays.sort(files, Collections.reverseOrder());
                Iterator<File> iter = Arrays.asList(files).iterator();
                this.stack.push(iter);
                return this.returnFile();
            }
            if (this.count++ > this.maxCount) {
                System.out.println("lasone was : ");
                return null;
            }
            String name = file.getAbsolutePath();
            if (this.count % 100L == 0L) {
                System.out.println(this.count + "   " + name);
            }
            if (name.contains("\\en\\")) {
                return file.getAbsolutePath();
            }
            this.stack.pop();
            return this.returnFile();
        }
        this.stack.pop();
        return this.returnFile();
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        String url = "jdbc:postgresql://139.191.254.83/geonmaesupdate?user=postgres&password=postgres";
        Class.forName("org.postgresql.Driver");
        return DriverManager.getConnection(url);
    }
}

