/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.emmutils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class GetStory {
    private static final String OUTPUT_DIR = "C:\\Documents and Settings\\buccist\\jproject\\GeoMatcher\\tobedebugged\\stories\\";

    public static void main(String[] args) {
        String url = "http://emm.jrc.it/rss?type=story&id=bbc-0d785401580e982d7c09e3ff9a2d345c&language=en";
        try {
            new GetStory().get(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void get(String url) throws IOException {
        String hash = url.replaceAll("(.*id=)", "").replaceAll("&.*", "");
        String lang = url.substring(url.indexOf("language=") + "language=".length());
        if (lang.contains("&")) {
            lang = lang.substring(0, lang.indexOf("&"));
        }
        System.out.println("Looking for story : " + hash + "  in " + lang);
        File stories = new File("Q:\\Stories");
        if (stories.exists()) {
            for (int i = 0; i < 100; ++i) {
                String dirname = this.getDay(i) + "/" + lang;
                File dir = new File(stories, dirname);
                if (!dir.exists()) continue;
                System.out.println(dir);
                File myFile = new File(dir, hash + ".story.xml");
                if (!myFile.exists()) continue;
                System.out.println("Found  in : " + dirname);
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(myFile), "utf-8");
                String newFile = OUTPUT_DIR + hash + ".story.xml";
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "utf-8");
                if (new File(newFile).exists()) {
                    throw new IOException("File already EXISTS!! " + newFile);
                }
                Utils.copy((Reader)reader, (Writer)writer);
                reader.close();
                writer.close();
                break;
            }
            System.err.println("Couldn't find the story!!!!");
            System.exit(-1);
        } else {
            System.err.println("Mount q: please!");
        }
    }

    private String getDay(int i) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.add(6, -i);
        return format.format(calendar.getTime());
    }
}

