/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.test.NewGeoChecker;
import it.jrc.geocoder.test.SimpleClassLoader;
import it.jrc.geocoder.test.SinglItemTesterInt;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import it.jrc.rtn.RTNClusterInfo;
import it.jrc.rtn.RTNClusterInfoParser;
import it.jrc.rtn.RTNItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame
implements ActionListener {
    NewGeoChecker checker = null;
    GeocodeMatcher matcher = null;
    ProcessRSS prss;
    boolean loaded = false;
    RTNClusterInfoParser rtnparser = new RTNClusterInfoParser();
    private JButton testBut;
    private JButton goBut;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane jTextPane1;
    private JTree jTree1;
    private JButton loafBut;
    private URL[] testerPath;
    private String testDir = "test/rsses3/";

    public MainFrame() {
        try {
            this.testerPath = new URL[]{new URL("file:/c:/Documents%20and%20Settings/buccist/jproject/GeoMatcher/build/classes")};
            this.checker = new NewGeoChecker();
            this.initComponents();
            this.myInit();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void myInit() {
        this.goBut.setText("Mark OK!");
        this.goBut.addActionListener(this);
        this.loafBut.addActionListener(this);
        this.loafBut.setText("MarkBad");
        this.testBut.addActionListener(this);
        this.startLoading();
        this.jTextPane1.setContentType("text/html");
        this.jTree1.setModel(this.getTreeModel());
        this.jTree1.setRootVisible(false);
        this.jTree1.setCellRenderer(new MyCellRenderer());
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = MainFrame.this.jTree1.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = MainFrame.this.jTree1.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    MainFrame.this.myDoubleClick(selRow, selPath);
                }
            }
        };
        this.jTree1.addMouseListener(ml);
    }

    private void startLoading() {
        new Thread(){

            public void run() {
                File webdir = new File("WebContent");
                String fullpath = webdir.getAbsolutePath() + File.separator;
                GeocodeMatcher m = new GeocodeMatcher();
                MainFrame.this.prss = m.init(fullpath, null);
                MainFrame.this.matcher = m;
                MainFrame.this.dataLoaded();
            }
        }.start();
    }

    protected void dataLoaded() {
        this.loaded = true;
    }

    protected void myDoubleClick(int selRow, TreePath selPath) {
        if (this.jTree1.getModel().isLeaf(selPath.getLastPathComponent())) {
            this.waitForLoading();
            String guid = this.getGuid(selPath);
            String fileName = this.getFileName(selPath);
            try {
                this.readItem(fileName, guid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLoading() {
        if (!this.loaded) {
            while (!this.loaded) {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    try {
                        Thread.currentThread().wait(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private String getFileName(TreePath selPath) {
        return (String)((DefaultMutableTreeNode)selPath.getParentPath().getLastPathComponent()).getUserObject();
    }

    private String getGuid(TreePath selPath) {
        return (String)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
    }

    private void readItem(String fileName, String guid) throws Exception {
        RTNClusterInfo[] clusterInfos;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(NewGeoChecker.testDir + "/" + fileName), "utf-8");
        for (RTNClusterInfo cluster : clusterInfos = this.rtnparser.parse((Reader)reader)) {
            cluster.combineItems();
            for (RTNItem item : cluster.getAllItems()) {
                if (!item.getGuid().equals(guid)) continue;
                RSSItem rssitem = item.getItem();
                String html = "<html>";
                html = html + "<b>Old</b> : " + rssitem.getElements("emm:georss").toString().replaceAll("\\<emm:georss", "").replaceAll("\\<\\/emm:georss\\>", "<br/>");
                html = html + "<br>";
                html = html + "<b>New</b> : " + rssitem.getElements("emm:newgeo").toString().replaceAll("\\<emm:newgeo", "").replaceAll("\\<\\/emm:newgeo\\>", "<br/>");
                for (SimpleElement other : rssitem.getElements()) {
                    if (!other.getName().matches("emm.newgeo[0-9]+")) continue;
                    html = html + "<b>OTHERS</b> : " + other.toString().replaceAll("\\<emm:newgeo[0-9]+", "").replaceAll("\\<\\/emm:newgeo[0-9]+\\>", "<br/>");
                }
                html = html + "<br>";
                html = html + "<b>guid</b> : " + guid;
                html = html + "<br>";
                html = html + "<b>Title</b> : " + item.getTitle();
                html = html + "<br>";
                html = html + "<b>Desc</b> : " + item.getDescription();
                html = html + item.getText();
                html = html + "<br>";
                html = html + "</html>";
                this.jTextPane1.setText(html);
                this.prss.runOnRSSItem(item.getItem(), true, 0, false);
            }
        }
    }

    public TreeModel getTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (String filename : this.checker.files.keySet()) {
            DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(filename);
            root.add(fileNode);
            for (String guid : this.checker.files.get(filename)) {
                DefaultMutableTreeNode guidNode = new DefaultMutableTreeNode(guid);
                fileNode.add(guidNode);
            }
        }
        return new DefaultTreeModel(root);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.goBut = new JButton();
        this.loafBut = new JButton();
        this.testBut = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.setDefaultCloseOperation(3);
        this.jSplitPane1.setDividerLocation(200);
        this.goBut.setText("Show");
        this.loafBut.setText("Load files");
        this.testBut.setText("Test Item");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.testBut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 109, Short.MAX_VALUE).addComponent(this.loafBut).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.goBut).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goBut).addComponent(this.loafBut).addComponent(this.testBut)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane2.setViewportView(this.jTextPane1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 354, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 325, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 580, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 405, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        TreePath path = this.jTree1.getSelectionPath();
        DefaultTreeModel model = (DefaultTreeModel)this.jTree1.getModel();
        try {
            if (e.getSource() == this.goBut) {
                if (this.jTree1.getModel().isLeaf(path.getLastPathComponent())) {
                    this.markOk(this.getFileName(path), this.getGuid(path), true);
                    TreePath parent = path.getParentPath();
                    DefaultMutableTreeNode object = (DefaultMutableTreeNode)parent.getLastPathComponent();
                    int newSel = object.getIndex((TreeNode)path.getLastPathComponent());
                    Object newSelection = model.getChild(parent.getLastPathComponent(), newSel);
                    if (newSelection != null) {
                        path = parent.pathByAddingChild(newSelection);
                        this.jTree1.setSelectionPath(path);
                        this.myDoubleClick(1, path);
                    }
                }
            } else if (e.getSource() == this.loafBut) {
                if (this.jTree1.getModel().isLeaf(path.getLastPathComponent())) {
                    this.markOk(this.getFileName(path), this.getGuid(path), false);
                    TreePath parent = path.getParentPath();
                    DefaultMutableTreeNode object = (DefaultMutableTreeNode)parent.getLastPathComponent();
                    int newSel = object.getIndex((TreeNode)path.getLastPathComponent());
                    Object newSelection = model.getChild(parent.getLastPathComponent(), newSel + 1);
                    if (newSelection != null) {
                        path = parent.pathByAddingChild(newSelection);
                        this.jTree1.setSelectionPath(path);
                        this.myDoubleClick(1, path);
                    }
                }
            } else if (e.getSource() == this.testBut && this.jTree1.getModel().isLeaf(path.getLastPathComponent())) {
                this.waitForLoading();
                SinglItemTesterInt tester = (SinglItemTesterInt)SimpleClassLoader.getNewClass("it.jrc.geocoder.test.SingleItemTester", this.testerPath[0]);
                tester.init(this.matcher.getMatchWord(), GeocodeMatcher.idmap, GeocodeMatcher.isomap, GeocodeMatcher.langmap);
                String text = tester.runOnFile(new File(this.testDir + this.getFileName(path)), this.getGuid(path));
                if (text != null) {
                    this.jTextPane1.setText(text);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JOptionPane.showMessageDialog(this, exc.getMessage(), "Problem!", 0);
        }
    }

    private void markOk(String fileName, String guid, boolean ok) throws Exception {
        RTNClusterInfo[] clusts;
        boolean found = false;
        block0: for (RTNClusterInfo clu : clusts = this.readFile(NewGeoChecker.testDir + "/" + fileName)) {
            clu.combineItems();
            for (RTNItem item1 : clu.getAllItems()) {
                if (!item1.getGuid().equals(guid)) continue;
                item1.getItem().addElement(new SimpleElement("emm:debug", ok ? "ok" : "bad"));
                if (ok) {
                    this.checker.badOnes.remove(guid);
                    this.checker.corrected.add(guid);
                } else {
                    this.checker.badOnes.add(guid);
                    this.checker.goodOnes.remove(guid);
                }
                this.jTree1.repaint();
                found = true;
                continue block0;
            }
        }
        if (!found) {
            throw new IOException("Impossible to find : " + guid + " in " + fileName);
        }
        this.writeFile(clusts, NewGeoChecker.testDir + "/" + fileName);
    }

    private RTNClusterInfo[] readFile(String file) throws Exception {
        InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        RTNClusterInfo[] clusterInfos = this.rtnparser.parse((Reader)read);
        read.close();
        return clusterInfos;
    }

    private void writeFile(RTNClusterInfo[] rtnci, String file) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"../clusters.xsl\"?>");
        writer.write("<clusters language=\"" + rtnci[0].getLanguage() + "\" xmlns:emm=\"http://emm.jrc.it\" xmlns:iso=\"http://www.iso.org/3166\">");
        for (RTNClusterInfo rtnInfo : rtnci) {
            for (RTNClusterInfo clus : rtnci) {
                clus.combineItems();
            }
            rtnInfo.toXML((Writer)writer);
            writer.write("\n");
        }
        writer.write("</clusters>");
        writer.close();
        System.out.println("SCRITTO");
    }

    private class OkIcon
    implements Icon {
        private boolean light;
        private int width = 16;
        private int height = 16;
        private BasicStroke stroke = new BasicStroke(2.0f);

        public OkIcon(boolean light) {
            this.light = light;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g2d.setColor(this.light ? Color.GREEN : new Color(0, 150, 0));
            g2d.setStroke(this.stroke);
            g2d.drawLine(x + 7, y + 9, x + this.width / 2, y + this.height - 5);
            g2d.drawLine(x + this.width - 5, y + 5, x + this.width / 2, y + this.height - 5);
            g2d.dispose();
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private class MissingIcon
    implements Icon {
        private int width = 16;
        private int height = 16;
        private BasicStroke stroke = new BasicStroke(3.0f);

        private MissingIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(Color.WHITE);
            g2d.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(x + 1, y + 1, this.width - 2, this.height - 2);
            g2d.setColor(Color.RED);
            g2d.setStroke(this.stroke);
            g2d.drawLine(x + 5, y + 5, x + this.width - 5, y + this.height - 5);
            g2d.drawLine(x + 5, y + this.height - 5, x + this.width - 5, y + 5);
            g2d.dispose();
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        Icon badIcon;
        Icon goodIcon;
        Icon correctedIcon;

        private MyCellRenderer() {
            this.badIcon = new MissingIcon();
            this.goodIcon = new OkIcon(false);
            this.correctedIcon = new OkIcon(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (leaf) {
                if (MainFrame.this.checker.corrected.contains(node.getUserObject())) {
                    this.setIcon(this.correctedIcon);
                } else if (MainFrame.this.checker.badOnes.contains(node.getUserObject())) {
                    this.setIcon(this.badIcon);
                } else if (MainFrame.this.checker.goodOnes.contains(node.getUserObject())) {
                    this.setIcon(this.goodIcon);
                }
                if (MainFrame.this.checker.empty.contains(node.getUserObject())) {
                    this.setForeground(Color.lightGray);
                }
            }
            return this;
        }
    }
}

