/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.geocoder.test.SteUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewGeoChecker {
    Logger logger = Logger.getLogger((String)NewGeoChecker.class.getName());
    HashMap<String, ArrayList<String>> files;
    HashSet<String> badOnes;
    HashSet<String> goodOnes;
    HashSet<String> empty;
    HashSet<String> corrected;
    public static String testDir = "test/rsses3";

    public NewGeoChecker() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        ArrayList<String> guids = null;
        this.files = new HashMap();
        this.badOnes = new HashSet();
        this.goodOnes = new HashSet();
        this.empty = new HashSet();
        this.corrected = new HashSet();
        for (File file : new File(testDir).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".xml");
            }
        })) {
            System.out.println("running on : " + file);
            try {
                Document doc = builder.parse(file);
                String newgeo = "/clusters/cluster/item";
                Object res = SteUtils.fastXpath(newgeo, doc, XPathConstants.NODESET);
                guids = new ArrayList<String>();
                NodeList list = (NodeList)res;
                for (int i = 0; i < list.getLength(); ++i) {
                    this.processItem(list.item(i), guids);
                }
                if (guids.size() <= 0) continue;
                this.files.put(file.getName(), guids);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)("Problem reading file : " + file), (Throwable)e);
            }
        }
    }

    private boolean processItem(Node item, ArrayList<String> guids) {
        NodeList list = item.getChildNodes();
        ArrayList<Node> oldgeos = new ArrayList<Node>();
        ArrayList<Node> newgeos = new ArrayList<Node>();
        String guid = null;
        TreeMap<String, ArrayList<Node>> allgeos = new TreeMap<String, ArrayList<Node>>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("guid")) {
                guid = node.getTextContent();
                continue;
            }
            if (nodeName.equals("emm:georss") || nodeName.matches("emm:newgeo[0-9]*")) {
                this.addToAll(node, allgeos, nodeName);
                continue;
            }
            if (!nodeName.equals("emm:debug") || !node.getTextContent().equalsIgnoreCase("ok")) continue;
            this.corrected.add(guid);
        }
        if (allgeos.size() >= 2) {
            String[] keys = allgeos.keySet().toArray(new String[allgeos.size()]);
            oldgeos = allgeos.get(keys[keys.length - 2]);
            newgeos = allgeos.get(keys[keys.length - 1]);
        } else if (allgeos.size() == 1) {
            newgeos = (ArrayList<Node>)allgeos.values().iterator().next();
        }
        if (newgeos.size() == 0) {
            this.empty.add(guid);
        }
        if (this.different(oldgeos, newgeos)) {
            this.badOnes.add(guid);
        } else {
            this.goodOnes.add(guid);
        }
        guids.add(guid);
        return false;
    }

    private void addToAll(Node node, TreeMap<String, ArrayList<Node>> allgeos, String nodeName) {
        ArrayList<Node> list = allgeos.get(nodeName);
        if (list == null) {
            list = new ArrayList();
            allgeos.put(nodeName, list);
        }
        list.add(node);
    }

    private boolean processItemOld(Node item, ArrayList<String> guids) {
        NodeList list = item.getChildNodes();
        ArrayList<Node> oldgeos = new ArrayList<Node>();
        ArrayList<Node> newgeos = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeName().equals("emm:debug")) {
                String guid = "";
                NodeList nodes = item.getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node guidnode = nodes.item(j);
                    if (!guidnode.getNodeName().equals("guid")) continue;
                    guid = guidnode.getTextContent();
                }
                if (node.getTextContent().equalsIgnoreCase("ok")) {
                    this.goodOnes.add(guid);
                    System.out.println(guid);
                    continue;
                }
                if (!node.getTextContent().equalsIgnoreCase("bad")) continue;
                System.err.println(guid);
                this.badOnes.add(guid);
                continue;
            }
            if (node.getNodeName().equals("emm:newgeo")) {
                newgeos.add(node);
                continue;
            }
            if (!node.getNodeName().equals("emm:georss")) continue;
            oldgeos.add(node);
        }
        if (oldgeos.size() != newgeos.size() || this.different(oldgeos, newgeos)) {
            NodeList nodes = item.getChildNodes();
            String guid = "";
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node guidnode = nodes.item(i);
                if (!guidnode.getNodeName().equals("guid")) continue;
                guid = guidnode.getTextContent();
            }
            guids.add(guid);
            return true;
        }
        return false;
    }

    private boolean different(ArrayList<Node> oldgeos, ArrayList<Node> newgeos) {
        if (oldgeos == null && newgeos == null) {
            return false;
        }
        if (oldgeos == null || newgeos == null) {
            return true;
        }
        for (Node newnode : newgeos) {
            boolean found = false;
            for (Node oldnode : oldgeos) {
                String oldid;
                String newid = newnode.getAttributes().getNamedItem("id").getTextContent();
                if (!newid.equals(oldid = oldnode.getAttributes().getNamedItem("id").getTextContent())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new NewGeoChecker();
    }
}

