/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsIntyTester {
    static ProcessRSS prss;

    public static void main(String[] args) {
        new OsIntyTester();
    }

    public OsIntyTester() {
        try {
            String fullpath = "WebContent/";
            GeocodeMatcher m = new GeocodeMatcher();
            System.out.println(fullpath);
            prss = m.init(fullpath, null);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("test/bbc_known.xml"), "utf-8");
            RSSParser parser = new RSSParser();
            RSS rss = parser.parse((Reader)reader);
            for (RSSItem item : rss.getItems()) {
                this.process(item, true);
            }
            this.checkForSuccessNames(rss.getItems(), "bbc-a402d6aee1ef3d9c4fb9c8cc5ab2325e", new String[]{"Sunderland", "Manchester", "Barrow", "Bolton"});
            this.checkForSuccessNames(rss.getItems(), "bbc-e770e1957c797255f258b9b52ea6c7fd", new String[]{"Gloucester", "Halifax", "Cheltenham", "Gloucestershire", "Bristol", "Cardiff", "Monmouth"});
            this.checkForSuccessNames(rss.getItems(), "bbc-331208436a753254f53ccd1a4011ef03", new String[]{"Dundee", "Tayside"});
            this.checkForSuccessNames(rss.getItems(), "bbc-864aae4c91be224dea9775b0252127b0", new String[]{"Britain", "Flint"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkForSuccessNames(Vector<RSSItem> items, String guid, String[] names) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(names));
        for (RSSItem item : items) {
            if (!item.getGuid().equals(guid)) continue;
            if (item.getGuid().equals("bbc-864aae4c91be224dea9775b0252127b0")) {
                System.out.println(item.getText());
            }
            ArrayList elements = item.getElements("emm:georss");
            System.out.println("guid : " + guid + "  " + elements.size());
            for (SimpleElement elem : elements) {
                String name = elem.getValue();
                if (list.remove(name)) continue;
                System.out.println("\tFound also value : " + name);
            }
            if (list.size() <= 0) continue;
            System.out.println("\tCould not find " + list);
        }
    }

    private boolean isPresent(String string, ArrayList<SimpleElement> elements) {
        for (SimpleElement simpleElement : elements) {
            SimpleAttribute attribute = simpleElement.getAttribute("id");
            if (!attribute.value.equals(string)) continue;
            return true;
        }
        return false;
    }

    public RSSItem process(RSSItem inputItem, boolean withoutTitle) {
        prss.runOnRSSItem(inputItem, withoutTitle, ProcessRSS.CLASS4);
        return inputItem;
    }
}

