/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.geocoder.GeocodeMatchResult;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.test.SinglItemTesterInt;
import it.jrc.geoutils.GeoResource;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import it.jrc.rtn.RTNClusterInfo;
import it.jrc.rtn.RTNClusterInfoParser;
import it.jrc.rtn.RTNItem;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleItemTester
implements SinglItemTesterInt {
    public static ProcessRSS prss;
    private static File outDir;

    public static void main(String[] args) {
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        SingleItemTester tester = new SingleItemTester();
        tester.init(null);
        try {
            if (args.length == 0) {
                for (String dir : args = new String[]{"test/rsses2/"}) {
                    for (File file : new File(dir).listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            boolean ret = pathname.getName().endsWith("clustersit6.xml");
                            System.out.println(pathname.getName() + "  " + ret);
                            return ret;
                        }
                    })) {
                        System.out.println("Running on : " + file);
                        try {
                            tester.runOnFile(file);
                        }
                        catch (Exception e) {
                            System.err.println("Problem reading file : " + file);
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                System.out.println("Running on " + args[0] + "  " + args[1]);
                tester.runOnFile(new File(args[0]), args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String runOnFile(File file, String guid) throws Exception {
        System.err.print("Running on : " + file + "  guid: " + guid);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        RTNClusterInfoParser rtnparser = new RTNClusterInfoParser();
        RTNClusterInfo[] rtnci = rtnparser.parse((Reader)reader);
        reader.close();
        ArrayList<SimpleElement> all = new ArrayList<SimpleElement>();
        for (RTNClusterInfo rtnInfo : rtnci) {
            RTNItem[] items;
            rtnInfo.combineItems();
            for (RTNItem item : items = rtnInfo.getAllItems()) {
                if (!item.getGuid().equals(guid)) continue;
                boolean useText = true;
                ArrayList<SimpleElement> found = prss.runOnRSSItem(item.getItem(), useText, 4, false);
                all.addAll(found);
                String ret = item.getTitle() + ". " + item.getDescription();
                if (useText) {
                    ret = item.getText();
                }
                TreeMap<Integer, Integer> mods = new TreeMap<Integer, Integer>();
                for (SimpleElement elem : all) {
                    String charpos = elem.getAttributeValue("charpos");
                    String wordlength = elem.getAttributeValue("wordlen");
                    String[] poss = charpos.split(",");
                    String[] lengths = wordlength.split(",");
                    for (int i = 0; i < poss.length; ++i) {
                        int pos = Integer.parseInt(poss[i]);
                        int len = Integer.parseInt(lengths[i]);
                        mods.put(pos, len);
                    }
                }
                int increment = 0;
                for (Integer pos : mods.keySet()) {
                    int len = (Integer)mods.get(pos);
                    ret = ret.substring(0, pos + increment) + "<b>" + ret.substring(pos + increment, pos + 1 + len + increment) + "</b>" + ret.substring(pos + 1 + len + increment);
                    increment += 7;
                }
                return ret;
            }
        }
        return null;
    }

    private void runOnFile(File file) throws Exception {
        boolean changed = false;
        ArrayList<String> chenged = new ArrayList<String>();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        RTNClusterInfoParser rtnparser = new RTNClusterInfoParser();
        RTNClusterInfo[] rtnci = rtnparser.parse((Reader)reader);
        reader.close();
        OutputStreamWriter writer = null;
        File newFile = new File(outDir, file.getName());
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "utf-8");
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("<?xml-stylesheet type=\"text/xsl\" href=\"../clusters.xsl\"?>");
        writer.write("<clusters language=\"" + rtnci[0].getLanguage() + "\" xmlns:emm=\"http://emm.jrc.it\" xmlns:iso=\"http://www.iso.org/3166\">");
        for (RTNClusterInfo rtnInfo : rtnci) {
            RTNItem[] items;
            rtnInfo.combineItems();
            block1: for (RTNItem item : items = rtnInfo.getAllItems()) {
                ArrayList<SimpleElement> found = prss.runOnRSSItem(item.getItem(), true, 0, false);
                if (this.isok(item)) {
                    this.processOk(item, found);
                    continue;
                }
                if (found != null) {
                    SingleItemTester.addNewGeo(item, found, "");
                }
                for (SimpleElement simpleElement : found) {
                    String newId = simpleElement.getAttributeValue("id");
                    boolean contains = false;
                    for (SimpleElement oldone : item.getItem().getElements("emm:geo")) {
                        String oldId = oldone.getAttributeValue("id");
                        if (!newId.equals(oldId)) continue;
                        contains = true;
                    }
                    if (contains) continue;
                    chenged.add(item.getItem().getGuid());
                    changed = true;
                    continue block1;
                }
            }
            rtnInfo.toXML((Writer)writer);
            writer.write("\n");
        }
        writer.write("</clusters>");
        writer.close();
    }

    private void processOk(RTNItem item, ArrayList<SimpleElement> found) {
        SimpleElement ok = (SimpleElement)item.getItem().getElements("emm:debug").get(0);
        if (!"bad".equals(ok.getValue())) {
            item.getItem().removeElement(ok);
        }
        String max = "emm:newgeo";
        for (SimpleElement all : item.getItem().getElements()) {
            if (!all.getName().startsWith("emm:newgeo")) continue;
            max = max.compareTo(all.getName()) > 0 ? max : all.getName();
        }
        ArrayList lastOnes = item.getItem().getElements(max);
        System.out.println(this.different(found, lastOnes));
        max = max.substring("emm:newgeo".length());
        String number = "1";
        if (max.length() > 0) {
            number = Integer.parseInt(max) + 1 + "";
        }
        SingleItemTester.addNewGeo(item, found, number);
    }

    private boolean different(ArrayList<SimpleElement> found, ArrayList<SimpleElement> lastOnes) {
        if (found.size() == lastOnes.size()) {
            for (SimpleElement f : found) {
                if (this.contains(f, lastOnes)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean contains(SimpleElement f, ArrayList<SimpleElement> lastOnes) {
        for (SimpleElement last : lastOnes) {
            if (!f.getAttributeValue("id").equals(last.getAttributeValue("id"))) continue;
            return true;
        }
        return false;
    }

    private boolean isok(RTNItem item) {
        ArrayList list = item.getItem().getElements("emm:debug");
        return list != null && list.size() > 0;
    }

    private static void addNewGeo(RTNItem item, ArrayList<SimpleElement> newones, String number) {
        HashMap<String, SimpleElement> map = new HashMap<String, SimpleElement>();
        for (SimpleElement simpleElement : newones) {
            map.put(simpleElement.getAttributeValue("id"), simpleElement);
        }
        for (SimpleElement newElement : map.values()) {
            SimpleElement newone = new SimpleElement("emm:newgeo" + number);
            ArrayList<SimpleAttribute> atts = new ArrayList<SimpleAttribute>();
            atts.add(new SimpleAttribute("name", newElement.getAttributeValue("name")));
            atts.add(new SimpleAttribute("id", newElement.getAttributeValue("id")));
            atts.add(new SimpleAttribute("lat", newElement.getAttributeValue("lat")));
            atts.add(new SimpleAttribute("lon", newElement.getAttributeValue("lon")));
            atts.add(new SimpleAttribute("count", newElement.getAttributeValue("count")));
            atts.add(new SimpleAttribute("wordpos", newElement.getAttributeValue("wordpos")));
            atts.add(new SimpleAttribute("class", newElement.getAttributeValue("class")));
            newone.setAttributes(atts);
            newone.setValue(newElement.getValue());
            item.getItem().addElement(newone);
        }
    }

    @Override
    public void init(MatchWords matcher) {
        File webdir = new File("WebContent");
        String fullpath = webdir.getAbsolutePath() + File.separator;
        GeocodeMatcher m = new GeocodeMatcher();
        prss = m.init(fullpath, matcher);
        GeocodeMatchResult result = new GeocodeMatchResult();
        ProcessRSS.matcher.match("L'america e' bella", (MatchResult)result);
        System.out.println(result.getAllPlaces());
        result = new GeocodeMatchResult();
        ProcessRSS.matcher.match("L'America e' bella", (MatchResult)result);
        System.out.println(result.getAllPlaces());
        result = new GeocodeMatchResult();
        ProcessRSS.matcher.match("l'america e' bella ", (MatchResult)result);
        System.out.println(result.getAllPlaces());
        result = new GeocodeMatchResult();
        ProcessRSS.matcher.match("l'America e' bella ", (MatchResult)result);
        System.out.println(result.getAllPlaces());
        System.exit(-1);
    }

    @Override
    public void init(MatchWords matcher, HashMap<Long, GeoResource> idmap, HashMap<String, Long> isomap, HashMap<String, Integer> langmap) {
        File webdir = new File("WebContent");
        String fullpath = webdir.getAbsolutePath() + File.separator;
        GeocodeMatcher m = new GeocodeMatcher();
        prss = m.init(fullpath, matcher, idmap, isomap, langmap);
    }

    static {
        outDir = new File("test/rsses3");
    }
}

