/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test;

import it.jrc.emmutils.Utils;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteUtils {
    static XPathFactory xfactory = XPathFactory.newInstance();

    public static Object fastXpath(String expr, Document doc, QName type) throws XPathExpressionException {
        XPath xpath = SteUtils.getXPath();
        XPathExpression messExpr = xpath.compile(expr);
        return messExpr.evaluate(doc, type);
    }

    public static XPath getXPath() {
        return xfactory.newXPath();
    }

    public static RSS copyRss(RSS original) {
        RSS ret = new RSS();
        ret.setTitle(original.getTitle());
        ret.setLink(original.getLink());
        ret.setDescription(original.getDescription());
        ret.setPubDate(original.getPubDate());
        ret.setGuid("");
        HashMap map = original.getNamespace();
        for (String ns : map.keySet()) {
            if ("emm".equals(ns) || "iso".equals(ns)) continue;
            ret.addNamespace(ns, (String)map.get(ns));
        }
        ret.getCategories().addAll(original.getCategories());
        return ret;
    }

    public static String arrayToString(Object[] arr, String separator) {
        if (arr != null) {
            StringBuilder ret = new StringBuilder();
            if (arr.length > 0) {
                ret.append(arr[0].getClass().getSimpleName() + "[");
            } else {
                ret.append("[");
            }
            for (Object object : arr) {
                if (object == null) {
                    ret.append("null");
                    continue;
                }
                ret.append(object.toString() + separator);
            }
            String thisone = ret.toString();
            return thisone.substring(0, thisone.length() - 2) + "]";
        }
        return "NULL![]";
    }

    public static String arrayToString(Object[] arr) {
        return SteUtils.arrayToString(arr, ", ");
    }

    public static void backup(File f, boolean deleteOriginal) throws IOException {
        if (f.exists()) {
            File backup = new File(f.getAbsolutePath() + ".old");
            if (backup.exists()) {
                backup.delete();
            }
            Utils.copy((InputStream)new FileInputStream(f), (OutputStream)new FileOutputStream(backup));
            if (deleteOriginal) {
                f.delete();
            }
        }
    }

    public static Object invoke(String method, Object obj, Object[] parms) {
        try {
            Class<?> classe = obj.getClass();
            Class[] parClasses = null;
            if (parms != null) {
                parClasses = new Class[parms.length];
                for (int i = 0; i < parClasses.length; ++i) {
                    if (parms[i] == null) {
                        System.err.println("nul!?!??!?");
                        parClasses[i] = Object.class;
                        continue;
                    }
                    parClasses[i] = parms[i].getClass();
                }
            }
            Method theMet = classe.getMethod(method, parClasses);
            return theMet.invoke(obj, parms);
        }
        catch (Exception e) {
            System.err.println("The original Exception was : ");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String[] capitalize(String[] arr) {
        String[] ret = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            String string;
            ret[i] = string = SteUtils.capitalize(arr[i]);
        }
        return ret;
    }

    public static void main(String[] args) {
        String[] pippo = new String[]{"", null, "c", "ciao", "Ciao"};
        System.out.println(SteUtils.arrayToString(SteUtils.capitalize(pippo)));
        System.out.println(SteUtils.invoke("toUpperCase", "ciao", null));
    }

    public static String capitalize(String string) {
        if (string != null && string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String escapeHtmlFull(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                b.append(ch);
                continue;
            }
            if (Character.isWhitespace(ch)) {
                b.append(" ");
                continue;
            }
            if (Character.isISOControl(ch)) continue;
            if (Character.isHighSurrogate(ch)) {
                int codePoint;
                if (i + 1 < s.length() && Character.isSurrogatePair(ch, s.charAt(i + 1)) && Character.isDefined(codePoint = Character.toCodePoint(ch, s.charAt(i + 1)))) {
                    b.append("&#").append(codePoint).append(";");
                }
                ++i;
                continue;
            }
            if (Character.isLowSurrogate(ch)) {
                ++i;
                continue;
            }
            if (!Character.isDefined(ch)) continue;
            b.append("&#").append((int)ch).append(";");
        }
        return b.toString();
    }

    public static long guessSize(RSSItem item) {
        long ret = item.getDescription().length() + item.getLink().length() + item.getTitle().length() + item.getText().length();
        return ret;
    }

    public static String cutoff(String text, int length) {
        if (text != null && text.length() > length) {
            return text.substring(0, length);
        }
        return text;
    }

    public static String arrayToString(Collection<String> coll, String sep) {
        return SteUtils.arrayToString(coll.toArray(), sep);
    }

    public static void delDir(File dir) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                SteUtils.delDir(child);
            }
            child.delete();
        }
        dir.delete();
    }
}

