/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.emmutils.HTTPStream;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

public class DebugSingle {
    static String _file = "test/vanni/es/20041222.xml";
    static String _guid = "53-ed6b3ccc8f0aa825668f0191bd8f031a";
    private String fullpath = "C:\\Documents and Settings\\buccist\\jproject\\GeoMatcher\\WebContent\\";
    public static ProcessRSS prss = null;
    ProcessRSS persistent = null;
    RSSParser parser = new RSSParser();

    public void check(String file, String guid) throws Exception {
        System.out.println("Debugging : " + file + "  guid: " + guid);
        RSS rss = this.getRss(file);
        this.takeAwayGeo(rss);
        this.leaveOnly(guid, rss);
        if (rss.getItems().size() == 0) {
            System.out.println("Can't find the selected item!!! " + file + " : " + guid);
        } else {
            if (prss == null) {
                prss = this.getProcessRSS();
            }
            String ret = prss.runForRSSMixed(rss);
            System.out.println("runForRSSMixed  " + ret);
        }
    }

    private ProcessRSS getProcessRSS() {
        if (this.persistent == null) {
            GeocodeMatcher m = new GeocodeMatcher();
            this.persistent = m.init(this.fullpath, null);
        }
        return this.persistent;
    }

    private void leaveOnly(String guid, RSS rss) {
        Iterator iterator = rss.getItems().iterator();
        while (iterator.hasNext()) {
            RSSItem item = (RSSItem)iterator.next();
            if (item.getGuid().equals(guid)) continue;
            iterator.remove();
        }
    }

    public static void main(String[] args) {
        try {
            String par1 = null;
            String par2 = null;
            if (args == null || args.length == 0) {
                par1 = _file;
                par2 = _guid;
            } else if (args.length == 2) {
                par1 = args[0];
                par2 = args[1];
            }
            System.out.println("Checking : " + par1);
            new DebugSingle().check(par1, par2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void takeAwayGeo(RSS rss) {
        for (RSSItem item : rss.getItems()) {
            if (item.getElements("emm:georss") == null || item.getElements("emm:georss").size() <= 0) continue;
            for (SimpleElement elem : item.getElements("emm:georss")) {
                item.removeElement(elem);
            }
        }
    }

    private RSS getRss(String file) throws Exception {
        InputStreamReader reader = null;
        reader = file.startsWith("http") ? new InputStreamReader((InputStream)new HTTPStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
        RSS rss = this.parser.parse((Reader)reader);
        reader.close();
        return rss;
    }
}

