/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.emmutils.HTTPStream;
import it.jrc.emmutils.Utils;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geocoder.kml.ItemToKml;
import it.jrc.geoutils.GeoUtils;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTopStory {
    String url = "http://emm.jrc.it/rss?type=24hrs&language=en&format=raw";
    private String fullpath = "WebContent/";
    Logger logger = Logger.getLogger((String)DebugTopStory.class.getName());
    private String outFile = "outGeores.kml";

    public static void main(String[] args) {
        try {
            new DebugTopStory().go();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void go() throws Exception {
        RSS rss = this.getRss();
        HashMap<String, ArrayList<SimpleElement>> oldGeo = this.stripGeo(rss);
        System.out.println("oldGeo : " + oldGeo.size());
        for (RSSItem item : rss.getItems()) {
            System.out.println(item.getElements("emm:georss") != null ? Integer.valueOf(item.getElements("emm:georss").size()) : null);
        }
        GeocodeMatcher m = new GeocodeMatcher();
        ProcessRSS prss = m.init(this.fullpath, null);
        String ret = prss.runForRSSMixed(rss);
        this.logger.info((Object)("runForRSSMixed  " + ret));
        ArrayList elems = GeoUtils.disambiguateGeoItems((Collection)rss.getItems());
        System.out.println(elems.toString().replaceAll(">,", ">,\n"));
        String kml = ItemToKml.itemToKml((Collection)rss.getItems());
        this.writeKml(kml);
    }

    private void writeKml(String kml) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), "utf-8");
        out.write(kml);
        out.close();
    }

    private HashMap<String, ArrayList<SimpleElement>> stripGeo(RSS rss) {
        HashMap<String, ArrayList<SimpleElement>> ret = new HashMap<String, ArrayList<SimpleElement>>();
        for (RSSItem item : rss.getItems()) {
            ret.put(item.getGuid(), item.getElements("emm:georss"));
            ArrayList mom = item.getElements("emm:georss");
            if (mom == null) continue;
            for (SimpleElement next : mom) {
                item.removeElement(next);
            }
        }
        return ret;
    }

    private RSS getRss() throws Exception {
        HTTPStream stream = new HTTPStream(this.url);
        InputStreamReader httpreader = new InputStreamReader((InputStream)stream);
        String momFile = "test/debugstories";
        if (!new File(momFile).exists()) {
            new File(momFile).mkdirs();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        String date = format.format(new Date());
        date = date.substring(0, date.length() - 1);
        momFile = momFile + "/story" + date + ".xml";
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(momFile), "utf-8");
        Utils.copy((Reader)httpreader, (Writer)writer);
        httpreader.close();
        writer.close();
        InputStreamReader inFileReader = new InputStreamReader((InputStream)new FileInputStream(momFile), "utf-8");
        RSSParser parser = new RSSParser();
        RSS rss = parser.parse((Reader)inFileReader);
        inFileReader.close();
        return rss;
    }
}

