/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.emmutils.HTTPStream;
import it.jrc.geocoder.test.debug.StoryChecker;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.steuu.SteUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class QuickDebug
extends JFrame
implements DropTargetListener,
ActionListener {
    private JButton jButton1;
    private JButton jButton2;
    private JList<String> jList1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JButton reloadB;
    private ArrayList<String> descr = null;
    StoryChecker chack = new StoryChecker();

    public QuickDebug() {
        this.initComponents();
        this.myInit();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                QuickDebug.this.chack.getPrss();
            }
        });
    }

    private void myInit() {
        this.setTitle("QuickDebug");
        this.setLocation(-1600, 0);
        this.jList1.setModel(new DefaultListModel());
        DropTarget target = new DropTarget(this, this);
        this.jButton1.addActionListener(this);
        this.jButton2.addActionListener(this);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    try {
                        QuickDebug.this.chack.check(QuickDebug.this.jTextField1.getText(), (String)QuickDebug.this.jList1.getSelectedValue());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.jTextField1.addActionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.jList1);
        this.jList1.setCellRenderer(new MyCellRenderer());
        final QuickDebug mom = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("saving : " + QuickDebug.this.jTextField1.getText());
                SteUtils.saveProperty((Object)mom, (String)"url", (String)QuickDebug.this.jTextField1.getText());
            }
        });
        String url = SteUtils.loadProperty((Object)this, (String)"url");
        if (url != null && !"".equals(url)) {
            this.jTextField1.setText(url);
            try {
                this.setUrl(url);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField1 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.reloadB = new JButton();
        this.setDefaultCloseOperation(3);
        this.jButton1.setText("Story");
        this.jButton2.setText("Single");
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.reloadB.setText("reload");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.reloadB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 191, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 223, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.reloadB)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new QuickDebug().setVisible(true);
            }
        });
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrop(0x40000000);
                String drop = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                final String dropp = drop = this.convertUrl(drop);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            QuickDebug.this.setUrl(dropp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(0x40000000);
                List filelist = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                this.setUrl(((File)filelist.get(0)).getAbsolutePath());
            } else {
                System.out.println("Not supported!!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String convertUrl(String drop) {
        if (drop.matches("http://emm.*\\.html")) {
            Matcher mat = Pattern.compile("/(..)/([a-zA-Z0-9_]*-[a-zA-Z-0-9]*)\\.html").matcher(drop);
            if (mat.find()) {
                String lang = mat.group(1);
                String guid = mat.group(2);
                drop = "http://emm.jrc.it/rss?type=story&id=" + guid + "&language=" + lang + "&format=raw";
            } else {
                System.err.println("No match found for : " + drop);
            }
        }
        return drop;
    }

    private void setUrl(String drop) throws Exception {
        this.jTextField1.setText(drop);
        RSSParser parser = new RSSParser();
        Reader reader = this.getReader(drop);
        try {
            RSS rss = parser.parse(reader);
            reader.close();
            DefaultListModel model = (DefaultListModel)this.jList1.getModel();
            model.clear();
            this.descr = new ArrayList();
            for (RSSItem item : rss.getItems()) {
                model.addElement(item.getGuid());
                String text = "<html><p><b>" + item.getTitle();
                text = text + "</b></p>";
                String desc = item.getDescription();
                int pos = 0;
                String mom = desc.substring(pos, Math.min(pos + 50, desc.length())) + "<br/>";
                for (pos = 50; pos < desc.length(); pos += 50) {
                    mom = mom + desc.substring(pos, Math.min(pos + 50, desc.length())) + "<br/>";
                }
                text = text + mom + "</html>";
                this.descr.add(text);
            }
            this.jList1.repaint();
        }
        catch (Exception e) {
            System.out.println("Can't parse : " + drop);
            e.printStackTrace();
        }
    }

    private Reader getReader(String drop) throws IOException {
        System.out.println("Opening " + drop);
        BufferedReader ret = null;
        ret = drop.startsWith("http://") ? new BufferedReader(new InputStreamReader((InputStream)new HTTPStream(drop), "utf-8")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(drop), "utf-8"));
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.jButton1) {
                this.chack.check(true, this.jTextField1.getText());
            } else if (e.getSource() == this.jButton2) {
                this.chack.check(this.jTextField1.getText(), this.jList1.getSelectedValue());
            } else if (e.getSource() == this.jTextField1) {
                this.setUrl(this.jTextField1.getText());
            } else if (e.getSource() == this.reloadB) {
                this.chack.clearPrss();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        QuickDebug.this.chack.getPrss();
                    }
                });
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setText(value.toString());
            try {
                String res = (String)QuickDebug.this.descr.get(index);
                String tipText = res != null ? res : value.toString();
                list.setToolTipText(tipText);
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Can't find : " + index);
            }
            return this;
        }
    }
}

