/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug;

import it.jrc.emmutils.HTTPStream;
import it.jrc.geocoder.GeocodeMatcher;
import it.jrc.geocoder.ProcessRSS;
import it.jrc.geoutils.GeoUtils;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class StoryChecker {
    static String fileName = "test/vanni.xml";
    private String fullpath = "WebContent/";
    static boolean full = true;
    Logger logger = Logger.getLogger((String)StoryChecker.class.getName());
    ProcessRSS myRss = null;
    RSSParser parser = new RSSParser();

    public static void main(String[] args) {
        try {
            String file = fileName;
            if (args != null && args.length > 0) {
                full = Boolean.parseBoolean(args[0]);
            }
            if (args != null && args.length > 1) {
                file = args[1];
            }
            System.out.println("Debugging story :" + file);
            new StoryChecker().check(full, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void check(boolean fullm, String file) throws Exception {
        RSS rss = this.getRss(file);
        if (full) {
            StoryChecker.takeAwayGeo(rss);
            ProcessRSS prss = this.getPrss();
            String ret = prss.runForRSSMixed(rss);
            this.logger.info((Object)("runForRSSMixed  " + ret));
        }
        ArrayList elems = GeoUtils.disambiguateGeoItems((Collection)rss.getItems());
        System.out.println(elems.toString().replaceAll(">,", ">,\n"));
    }

    public void check(String file, String guid) throws Exception {
        System.out.println("Debugging : " + file + "  guid: " + guid);
        RSS rss = this.getRss(file);
        StoryChecker.takeAwayGeo(rss);
        this.leaveOnly(guid, rss);
        if (rss.getItems().size() == 0) {
            System.out.println("Can't find the selected item!!! " + file + " : " + guid);
        } else {
            ProcessRSS prss = this.getPrss();
            String ret = prss.runForRSSMixed(rss);
            System.out.println("runForRSSMixed  " + ret);
        }
    }

    private void leaveOnly(String guid, RSS rss) {
        Iterator iterator = rss.getItems().iterator();
        while (iterator.hasNext()) {
            RSSItem item = (RSSItem)iterator.next();
            if (item.getGuid().equals(guid)) continue;
            iterator.remove();
        }
    }

    public synchronized ProcessRSS getPrss() {
        if (this.myRss == null) {
            GeocodeMatcher m = new GeocodeMatcher();
            this.myRss = m.init(this.fullpath, null);
        }
        return this.myRss;
    }

    public static void takeAwayGeo(RSS rss) {
        for (RSSItem item : rss.getItems()) {
            if (item.getElements("emm:georss") == null) continue;
            for (SimpleElement elem : item.getElements("emm:georss")) {
                item.removeElement(elem);
            }
        }
    }

    private RSS getRss(String file) throws Exception {
        InputStreamReader reader = null;
        reader = file.startsWith("http") ? new InputStreamReader((InputStream)new HTTPStream(file), "utf-8") : new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
        return this.parser.parse((Reader)reader);
    }

    public void clearPrss() {
        this.myRss = null;
    }
}

