/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug.xml;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

public class TagView
extends BoxView {
    private boolean isExpanded = true;
    public static final int AREA_SHIFT = 10;

    public TagView(Element elem) {
        super(elem, 1);
        this.setInsets((short)0, (short)12, (short)0, (short)0);
    }

    public float getAlignment(int axis) {
        return 0.0f;
    }

    public void paint(Graphics g, Shape alloc) {
        Rectangle a = alloc instanceof Rectangle ? (Rectangle)alloc : alloc.getBounds();
        Shape oldClip = g.getClip();
        if (!this.isExpanded()) {
            Area newClip = new Area(oldClip);
            newClip.intersect(new Area(a));
            g.setClip(newClip);
        }
        super.paint(g, a);
        if (this.getViewCount() > 1) {
            g.setClip(oldClip);
            --a.width;
            --a.height;
            g.setColor(Color.lightGray);
            g.drawRect(a.x, a.y + 5, 10, 10);
            if (!this.isExpanded()) {
                g.drawLine(a.x + 5, a.y + 5 + 2, a.x + 5, a.y + 5 + 10 - 2);
            } else {
                g.drawLine(a.x + 5, a.y + 15, a.x + 5, a.y + a.height);
                g.drawLine(a.x + 5, a.y + a.height, a.x + 10, a.y + a.height);
            }
            g.drawLine(a.x + 2, a.y + 10, a.x + 10 - 2, a.y + 10);
        }
    }

    public float getPreferredSpan(int axis) {
        if (this.isExpanded() || axis != 1) {
            return super.getPreferredSpan(axis);
        }
        View firstChild = this.getView(0);
        return (float)this.getTopInset() + firstChild.getPreferredSpan(1);
    }

    public float getMinimumSpan(int axis) {
        if (this.isExpanded() || axis != 1) {
            return super.getMinimumSpan(axis);
        }
        View firstChild = this.getView(0);
        return (float)this.getTopInset() + firstChild.getMinimumSpan(1);
    }

    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    protected int getNextEastWestVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int newPos = super.getNextEastWestVisualPositionFrom(pos, b, a, direction, biasRet);
        if (!this.isExpanded()) {
            if (newPos >= this.getStartOffset() && newPos < this.getView(0).getView(0).getEndOffset()) {
                return newPos;
            }
            if (newPos >= this.getView(0).getView(0).getEndOffset()) {
                newPos = direction == 3 ? Math.min(this.getDocument().getLength() - 1, this.getEndOffset()) : this.getView(0).getView(0).getEndOffset() - 1;
            }
        }
        return newPos;
    }
}

