/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geocoder.test.debug.xml;

import it.jrc.geocoder.test.debug.xml.TagView;
import it.jrc.geocoder.test.debug.xml.XMLDocument;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class XMLViewFactory
implements ViewFactory {
    XMLViewFactory() {
    }

    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new LabelView(elem);
            }
            if (kind.equals(XMLDocument.TAG_ELEMENT)) {
                return new TagView(elem);
            }
            if (kind.equals(XMLDocument.TAG_ROW_START_ELEMENT) || kind.equals(XMLDocument.TAG_ROW_END_ELEMENT)) {
                return new BoxView(elem, 0){

                    public float getAlignment(int axis) {
                        return 0.0f;
                    }

                    public float getMaximumSpan(int axis) {
                        return this.getPreferredSpan(axis);
                    }
                };
            }
            if (kind.equals("section")) {
                return new BoxView(elem, 1);
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new LabelView(elem);
    }
}

