/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geoutils;

import it.jrc.emmutils.Template;
import it.jrc.rss.SimpleElement;
import java.io.IOException;

public class EMMGeo {
    double lat = 360.0;
    double lon = 360.0;
    private long gid = -1L;
    String placepath = "";
    String name = "";

    public EMMGeo(String slat, String slon) {
        try {
            this.lat = Double.parseDouble(slat);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lon = Double.parseDouble(slon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EMMGeo(SimpleElement element) {
        try {
            this.lat = Double.parseDouble(element.getAttributeValue("lat"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lon = Double.parseDouble(element.getAttributeValue("lon"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setGid(Long.parseLong(element.getAttributeValue("id")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.name = element.getValue();
        this.placepath = element.getAttributeValue("name");
        if (this.name == null || this.name.length() == 0) {
            this.name = this.placepath.split(":")[0];
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof EMMGeo && ((EMMGeo)obj).lat == this.lat && ((EMMGeo)obj).lon == this.lon;
    }

    public int hashCode() {
        return (Double.toString(this.lat) + " " + Double.toString(this.lon)).hashCode();
    }

    public String toString() {
        return Double.toString(this.lat) + " " + Double.toString(this.lon);
    }

    public void toXML(Template template) throws IOException {
        template.setParameter("emmgeo", Long.toString(this.getGid()));
        template.setParameter("emmgeopath", this.placepath.replace(':', ','));
        template.setParameter("emmgeolat", Double.toString(this.lat));
        double lat2 = this.lat + 2.0;
        template.setParameter("emmgeolatp2", Double.toString(lat2));
        template.setParameter("emmgeolon", Double.toString(this.lon));
        template.setParameter("emmgeoname", this.name);
    }

    public static EMMGeo parseText(String text) {
        int bpos = text.indexOf("(");
        int lpos = text.indexOf(")");
        String[] lonlat = text.substring(bpos + 1, lpos).split(" ");
        return new EMMGeo(lonlat[1], lonlat[0]);
    }

    public void setGid(long gid) {
        this.gid = gid;
    }

    public long getGid() {
        return this.gid;
    }
}

