/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geoutils;

import it.jrc.emmutils.Template;
import it.jrc.emmutils.Utils;
import it.jrc.geoutils.GeoResource;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import it.jrc.rtn.RTNClusterData;
import it.jrc.rtn.RTNClusterInfo;
import it.jrc.rtn.RTNItem;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoCluster
implements Comparable<GeoCluster> {
    protected GeoResource latlon;
    protected String title;
    protected String transtitle;
    protected String transdesc;
    protected String description;
    protected String language;
    protected String pubDate;
    protected String guid;
    public int size;
    protected String link;
    protected String type;
    protected ArrayList<RSSItem> items;
    public RSSItem source;
    public static SimpleDateFormat RFC822 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
    public static SimpleDateFormat DBDATE = new SimpleDateFormat("yyyy-MM-dd HH:mmZ");
    public static final ArrayList<RSSItem> ZEROITEMS = new ArrayList();
    public static final GeoResource ZEROLATLON = new GeoResource("NULL");
    protected static Integer lev = new Integer(0);

    public GeoCluster(RTNClusterInfo info, GeoResource ll) {
        this.latlon = ll;
        this.title = info.getTitle();
        this.description = info.getDescription();
        this.language = info.getLanguage();
        this.pubDate = info.getPubDate();
        this.guid = info.getId();
        this.size = info.getAllItems().length;
        if (this.size == 0) {
            this.size = info.getItems().size();
        }
        this.link = "http://press.jrc.it/storyedition/en/" + info.getId() + ".html";
        this.type = info.getType() == null ? "cloud" : info.getType();
        Collection<RTNItem> rtnitems = info.getItems().values();
        this.items = new ArrayList(rtnitems.size());
        boolean donetrans = false;
        for (RTNItem item : rtnitems) {
            this.items.add(item.getItem());
            if (donetrans) continue;
            donetrans = this.setTrans(item.getItem().getElements("emm:trans"));
        }
        this.source = this.setClusterSource(rtnitems);
    }

    public GeoCluster(RTNClusterData info, GeoResource ll) {
        this.latlon = ll;
        this.title = info.getTitle();
        this.description = info.getDescription();
        this.language = info.getLanguage();
        this.pubDate = info.getPubDate();
        this.guid = info.getId();
        this.size = info.getAllItems().length;
        this.link = "http://press.jrc.it/storyedition/en/" + info.getId() + ".html";
        this.type = info.getType() == null ? "cloud" : info.getType();
        this.items = new ArrayList(info.getAllItems().length);
        for (RTNItem item : info.getAllItems()) {
            this.items.add(item.getItem());
        }
    }

    public GeoCluster(RSSItem info, GeoResource ll, String id) {
        this.latlon = ll;
        this.title = info.getTitle();
        this.description = info.getDescription();
        this.language = info.getLanguage();
        this.pubDate = info.getPubDate();
        this.guid = info.getGuid();
        if (id != null) {
            this.guid = id;
        }
        this.items = ZEROITEMS;
        this.type = info.getAttributeValue("type");
        if (this.type == null) {
            // empty if block
        }
        this.type = "cloud";
        this.size = 1;
        this.link = info.getLink();
    }

    public GeoCluster(RSSItem info, GeoResource ll) {
        this.latlon = ll;
        this.title = info.getTitle();
        this.description = info.getDescription();
        this.language = info.getLanguage();
        this.pubDate = info.getPubDate();
        this.guid = info.getGuid();
        this.items = ZEROITEMS;
        this.type = info.getAttributeValue("type");
        if (this.type == null) {
            // empty if block
        }
        this.type = "cloud";
        this.size = 1;
        this.link = info.getLink();
    }

    private boolean setTrans(ArrayList<SimpleElement> elems) {
        if (elems == null || elems.size() < 1) {
            return false;
        }
        this.transtitle = elems.get(0).getAttributeValue("title");
        this.transdesc = elems.get(0).getAttributeValue("desc");
        return true;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            return this.guid.equals(((GeoCluster)obj).guid);
        }
        return false;
    }

    @Override
    public int compareTo(GeoCluster o) {
        return o.getSize() - this.getSize();
    }

    public int getSize() {
        return this.size;
    }

    public GeoResource getLatLon() {
        return this.latlon;
    }

    public long getID() {
        return this.latlon.gid;
    }

    public String getIcon() {
        return this.getType() + this.language;
    }

    public void toXMLItems(Template template, String prefix) {
        if (this.items == null || this.items.size() == 0) {
            return;
        }
        for (RSSItem item : this.items) {
            template.clearParameters(prefix);
            template.setParameter(prefix + "stitle", Utils.encodeXML((String)this.getShort(this.title, 50)));
            template.setParameter(prefix + "title", Utils.encodeXML((String)item.getTitle()));
            template.setParameter(prefix + "desc", Utils.encodeXML((String)item.getDescription()));
            template.setParameter(prefix + "link", Utils.encodeXML((String)item.getLink()));
            template.setParameter(prefix + "pubdate", item.getPubDate());
            template.setParameter(prefix + "lang", item.getLanguage());
            template.setParameter(prefix + "guid", item.getGuid());
            template.expandMacro(prefix);
        }
    }

    public void toXML(Template template, String prefix) throws IOException {
        template.setParameter(prefix + "stitle", Utils.encodeXML((String)this.getShort(this.title, 50)));
        template.setParameter(prefix + "title", Utils.encodeXML((String)this.title));
        template.setParameter(prefix + "desc", Utils.encodeXML((String)this.description));
        template.setParameter(prefix + "link", Utils.encodeXML((String)this.link));
        template.setParameter(prefix + "pubdate", this.pubDate);
        template.setParameter(prefix + "lang", this.language);
        template.setParameter(prefix + "guid", this.guid);
        template.setParameter(prefix + "articles", Integer.toString(this.items.size()));
        template.setParameter(prefix + "size", Integer.toString(this.size));
        if (this.latlon != null && this.latlon != ZEROLATLON) {
            this.latlon.toXML(template);
        }
    }

    public String getShort(String title, int size) {
        if (title.length() < size) {
            return title;
        }
        String stitle = title.substring(0, size - 1);
        int i = stitle.lastIndexOf(32);
        i = stitle.lastIndexOf(45) > i ? stitle.lastIndexOf(45) : i;
        i = stitle.lastIndexOf(44) > i ? stitle.lastIndexOf(44) : i;
        int n = i = stitle.lastIndexOf(46) > i ? stitle.lastIndexOf(46) : i;
        if (i > 0 && i > size / 2) {
            return stitle.substring(0, i) + "...";
        }
        return stitle + "...";
    }

    public void toXMLCluster(Template template, int geosize, int maxsize) throws IOException {
        int realsize = this.size;
        this.size = geosize;
        this.toXML(template, "cluster");
        this.size = realsize;
        template.setParameter("clusteratrtype", " type=\"" + this.type + this.language + "\" ");
        template.setParameter("clustertype", this.type);
        template.setParameter("clusterlevel", Integer.toString(this.getLevel()));
        template.setParameter("clusterlang", this.language);
        template.setParameter("clustermaxsize", Integer.toString(maxsize));
        template.setParameter("clustericon", this.getIcon());
        if (this.latlon != null && this.latlon != ZEROLATLON) {
            template.setParameter("clustid", Long.toString(this.latlon.gid));
        }
    }

    public RSSItem setClusterSource(Collection<RTNItem> rtnitems) {
        double dmax = 0.0;
        RTNItem toret = null;
        for (RTNItem it : rtnitems) {
            try {
                double d = it.getDistance();
                if (!(d > dmax)) continue;
                dmax = d;
                toret = it;
            }
            catch (Exception e) {}
        }
        return toret.getItem();
    }

    public String getType() {
        return this.type;
    }

    public Integer getLevel() {
        return lev;
    }
}

