/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geoutils;

import it.jrc.emmutils.Template;
import it.jrc.geoutils.GeoCluster;
import it.jrc.geoutils.GeoResource;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import it.jrc.rtn.RTNClusterData;
import it.jrc.rtn.RTNClusterInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class GeoEvent
extends GeoCluster {
    public String etype;
    public String itype;
    public String subtype;
    public Date firstItem;
    public Date lastItem;
    public Date genDate;
    public int deadcount = 0;
    public int injuredcount = 0;
    public int kidnappedcount = 0;
    public String actors;
    public String dead;
    public String injured;
    public String weapons;
    public int displacedcount = 0;
    public int homelesscount = 0;
    public String displaced;
    public String homeless;
    public String icon = "VE";
    private static Integer ZERO = new Integer(0);
    private static Integer ONE = new Integer(1);
    private static Integer TWO = new Integer(2);
    private static String VEEXISTS = "AR,RE,VI,NONE,KD";

    public boolean equals(GeoEvent test) {
        return this.testString(this.etype, test.etype) && this.deadcount == test.deadcount && this.injuredcount == test.injuredcount && this.kidnappedcount == test.kidnappedcount && this.testString(this.actors, test.actors) && this.testString(this.dead, test.dead) && this.testString(this.injured, test.injured) && this.testString(this.weapons, test.weapons) && this.testString(this.displaced, test.displaced) && this.testString(this.homeless, test.homeless) && this.displacedcount == test.displacedcount && this.homelesscount == test.homelesscount && this.subtype == test.subtype;
    }

    public boolean testString(String source, String test) {
        return source != null && test != null && source.equals(test);
    }

    public GeoEvent(RTNClusterInfo info, GeoResource ll, boolean gen) {
        super(info, ll);
        ArrayList events = info.getEvents();
        if (events != null && events.size() > 0) {
            this.initFromElement((SimpleElement)events.get(0));
        }
        if (gen) {
            this.genDate = new Date();
        }
    }

    public GeoEvent(RTNClusterInfo info, boolean gen) {
        super(info, null);
        ArrayList events = info.getEvents();
        if (events != null && events.size() > 0) {
            this.initFromElement((SimpleElement)events.get(0));
        }
        if (gen) {
            this.genDate = new Date();
        }
    }

    public GeoEvent(RTNClusterData info, GeoResource ll, boolean gen) {
        super(info, ll);
        ArrayList events = info.getEvents();
        if (events != null && events.size() > 0) {
            this.initFromElement((SimpleElement)events.get(0));
        }
        if (gen) {
            this.genDate = new Date();
        }
    }

    public GeoEvent(RSSItem info, GeoResource ll, SimpleElement elem, boolean gen) {
        super(info, ll);
        this.initFromElement(elem);
        if (gen) {
            this.genDate = new Date();
        }
    }

    private void initFromElement(SimpleElement elem) {
        this.etype = elem.getAttributeValue("type");
        this.icon = elem.getAttributeValue("icon");
        this.itype = elem.getAttributeValue("icode");
        this.subtype = elem.getAttributeValue("subtype");
        if (this.icon == null) {
            this.icon = "NONE";
        } else {
            this.itype = this.icon = this.icon.split("\\.")[0];
        }
        try {
            this.firstItem = GeoCluster.RFC822.parse(elem.getAttributeValue("generated"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.firstItem = GeoCluster.RFC822.parse(elem.getAttributeValue("firstitem"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lastItem = GeoCluster.RFC822.parse(elem.getAttributeValue("lastitem"));
        }
        catch (Exception e) {
            this.lastItem = this.firstItem;
        }
        try {
            this.genDate = GeoCluster.RFC822.parse(elem.getAttributeValue("generated"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.deadcount = Integer.parseInt(elem.getAttributeValue("dcount"));
        }
        catch (Exception e) {
            this.deadcount = 0;
        }
        try {
            this.injuredcount = Integer.parseInt(elem.getAttributeValue("icount"));
        }
        catch (Exception e) {
            this.injuredcount = 0;
        }
        try {
            this.kidnappedcount = Integer.parseInt(elem.getAttributeValue("kcount"));
        }
        catch (Exception e) {
            this.kidnappedcount = 0;
        }
        try {
            this.displacedcount = Integer.parseInt(elem.getAttributeValue("dispcount"));
        }
        catch (Exception e) {
            this.displacedcount = 0;
        }
        try {
            this.homelesscount = Integer.parseInt(elem.getAttributeValue("hcount"));
        }
        catch (Exception e) {
            this.homelesscount = 0;
        }
        this.actors = elem.getAttributeValue("actors");
        this.dead = elem.getAttributeValue("dead");
        this.injured = elem.getAttributeValue("injured");
        this.weapons = elem.getAttributeValue("weapons");
        this.homeless = elem.getAttributeValue("homeless");
        this.displaced = elem.getAttributeValue("displaced");
        this.size = this.getSize();
    }

    public SimpleElement asElement(String tag) {
        SimpleElement elem = new SimpleElement(tag);
        elem.addAttribute("type", this.etype);
        elem.addAttribute("ecode", this.icon);
        elem.addAttribute("icode", this.itype);
        if (this.subtype != null) {
            elem.addAttribute(this.subtype);
        }
        this.type = this.getType();
        if (this.genDate != null) {
            elem.addAttribute("generated", RFC822.format(this.genDate));
        }
        if (this.firstItem != null) {
            elem.addAttribute("firstitem", RFC822.format(this.firstItem));
        }
        if (this.lastItem != null) {
            elem.addAttribute("lastitem", RFC822.format(this.lastItem));
        }
        if (this.isHumanitarianEvent()) {
            elem.addAttribute("dispcount", Integer.toString(this.displacedcount));
            elem.addAttribute("hcount", Integer.toString(this.homelesscount));
            this.addStringAttribute("displaced", this.displaced, elem);
            this.addStringAttribute("homeless", this.homeless, elem);
        } else if (this.isViolentEvent()) {
            elem.addAttribute("dcount", Integer.toString(this.deadcount));
            elem.addAttribute("icount", Integer.toString(this.injuredcount));
            elem.addAttribute("kcount", Integer.toString(this.kidnappedcount));
            this.addStringAttribute("actors", this.actors, elem);
            this.addStringAttribute("dead", this.dead, elem);
            this.addStringAttribute("injured", this.injured, elem);
            this.addStringAttribute("weapons", this.weapons, elem);
        } else {
            elem.addAttribute("dcount", Integer.toString(this.deadcount));
            elem.addAttribute("icount", Integer.toString(this.injuredcount));
            this.addStringAttribute("dead", this.dead, elem);
            this.addStringAttribute("injured", this.injured, elem);
        }
        return elem;
    }

    private void addStringAttribute(String attr, String value, SimpleElement elem) {
        if (value != null && value.length() > 0) {
            elem.addAttribute(attr, value);
        }
    }

    public int getSize() {
        int lsize = this.deadcount * 1 + this.injuredcount * 1 + this.kidnappedcount + this.displacedcount + this.homelesscount;
        return lsize;
    }

    public void toXML(Template template, String prefix) throws IOException {
        this.type = this.getType();
        super.toXML(template, prefix);
        template.setParameter(prefix + "etype", this.etype);
        template.setParameter(prefix + "rfcfirstitem", GeoCluster.RFC822.format(this.firstItem));
        template.setParameter(prefix + "rfclastitem", GeoCluster.RFC822.format(this.lastItem));
        template.setParameter(prefix + "rfcgendate", GeoCluster.RFC822.format(this.genDate));
        template.setParameter(prefix + "itype", this.itype);
        template.setParameter(prefix + "source", this.getSource());
        template.setParameter(prefix + "level", this.getLevel().toString());
        template.setParameter(prefix + "type", this.type);
        template.setParameter(prefix + "code", this.icon);
        template.setParameter(prefix + "subtype", this.subtype);
        template.setParameter(prefix + "metadesc", this.descString());
        if (this.isHumanitarianEvent()) {
            template.setParameter(prefix + "displacedcount", this.getCount(this.displacedcount));
            template.setParameter(prefix + "homelesscount", this.getCount(this.homelesscount));
            template.setParameter(prefix + "displaced", this.substText(this.displaced));
            template.setParameter(prefix + "homeless", this.substText(this.homeless));
        } else if (this.isViolentEvent()) {
            template.setParameter(prefix + "killedcount", this.getCount(this.deadcount));
            template.setParameter(prefix + "injuredcount", this.getCount(this.injuredcount));
            template.setParameter(prefix + "kidnappedcount", this.getCount(this.kidnappedcount));
            template.setParameter(prefix + "actors", this.getString(this.actors));
            template.setParameter(prefix + "dead", this.substText(this.dead));
            template.setParameter(prefix + "injured", this.substText(this.injured));
            template.setParameter(prefix + "weapons", this.getString(this.weapons));
        } else {
            template.setParameter(prefix + "killedcount", this.getCount(this.deadcount));
            template.setParameter(prefix + "injuredcount", this.getCount(this.injuredcount));
            template.setParameter(prefix + "dead", this.substText(this.dead));
            template.setParameter(prefix + "injured", this.substText(this.injured));
        }
    }

    private String descString() {
        StringBuffer sb = new StringBuffer("Event Type:");
        sb.append("<b>").append(this.etype).append("</b>. Severity :<b>");
        if (this.isHumanitarianEvent()) {
            sb.append(this.displacedcount).append("</b> Displaced and <b>").append(this.homelesscount).append("</b> Homeless. Displaced were <b>");
            sb.append(this.getString(this.displaced)).append("</b> and homeless were <b>").append(this.getString(this.homeless)).append("</b>.");
        } else if (this.isViolentEvent()) {
            sb.append(this.deadcount).append("</b> Killed, <b>").append(this.injuredcount).append("</b> Injured and <b>").append(this.kidnappedcount).append("</b> kidnapped.");
            sb.append("Victims were <b>").append(this.getString(this.dead)).append("</b> killed and <b>").append(this.getString(this.injured));
            sb.append("</b>injured. Perpetrators were <b>").append(this.getString(this.actors)).append("</b> and the weapons used were <b>").append(this.getString(this.weapons)).append("</b>.");
        } else {
            sb.append(this.deadcount).append("</b> Killed, <b>").append(this.injuredcount).append("</b> Injured and <b>").append(this.kidnappedcount).append("</b> .");
            sb.append("Victims were <b>").append(this.getString(this.dead)).append("</b> killed and <b>").append(this.getString(this.injured)).append("</b> injured.");
        }
        return sb.toString();
    }

    private String getString(String toget) {
        return toget == null || toget.length() == 0 ? " not reported" : toget;
    }

    private String getCount(int count) {
        if (count < 0) {
            return "Undefined";
        }
        return Integer.toString(count);
    }

    private String substText(String oldvalue) {
        if (oldvalue == null || oldvalue.length() == 0) {
            return " no one ";
        }
        return oldvalue.replaceAll(",", "/");
    }

    private String getSource() {
        RSSItem item = this.source;
        if (item == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("<source url=\"");
        sb.append(item.getSourceUrl()).append("\" country=\"").append(item.getSourceCountry()).append("\" rank=\"");
        sb.append(item.getSourceRank()).append("\" >").append(item.getSource()).append("</source>");
        return sb.toString();
    }

    public boolean isViolentEvent() {
        try {
            int val = Integer.parseInt(this.itype);
            if (val < 2000 && val >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isHumanitarianEvent() {
        try {
            int val = Integer.parseInt(this.itype);
            if (val >= 4000) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Integer getLevel() {
        if (this.getSize() > 100) {
            return TWO;
        }
        if (this.getSize() > 10) {
            return ONE;
        }
        return ZERO;
    }

    public String getIcon() {
        return this.getType();
    }

    public String getType() {
        String t = this.icon;
        if (this.isViolentEvent()) {
            if (this.deadcount > 0) {
                t = "killed";
            } else if (this.injuredcount > 0) {
                t = "injured";
            } else if (t == null || !VEEXISTS.contains(t)) {
                t = "NONE";
            }
        }
        return t;
    }
}

