/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geoutils;

import it.jrc.emmutils.Template;
import it.jrc.geoutils.GeoCluster;
import it.jrc.geoutils.GeoEvent;
import it.jrc.geoutils.GeoResource;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import it.jrc.rtn.RTNClusterData;
import it.jrc.rtn.RTNClusterInfo;
import it.jrc.rtn.RTNClusterInfoParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoFormatter {
    private static Logger logger = Logger.getLogger((String)"it.jrc.geoformatter");
    public Map<Long, PriorityQueue<GeoCluster>> clusters;
    private ArrayList<String> icons;
    public Template template;
    public HashMap<String, String> global = new HashMap();

    public GeoFormatter() {
        this.clusters = new HashMap<Long, PriorityQueue<GeoCluster>>();
    }

    public GeoFormatter(String[] cols, String[] stats) {
        this.clusters = new HashMap<Long, PriorityQueue<GeoCluster>>();
    }

    public void initTemplate(Template temp) {
        this.template = temp;
    }

    public void initTemplate(String path) throws Exception {
        this.template = new Template();
        this.template.parse(new File(path));
    }

    public void setTemplateParameter(String name, String value) {
        this.global.put(name, value);
    }

    public void buildGeoClusters(RTNClusterData[] input) {
        this.clearClusters();
        if (input.length > 0) {
            for (int loop = 0; loop < input.length; ++loop) {
                if (input[loop] == null || input[loop].getGeo() == null) continue;
                for (SimpleElement element : input[loop].getGeo()) {
                    GeoResource geo = new GeoResource(element);
                    this.addGeo(this.createGeoCluster(input[loop], geo));
                }
            }
        }
    }

    public void buildGeoClusters(RTNClusterInfo[] input) {
        this.clearClusters();
        if (input != null && input.length > 0) {
            for (int loop = 0; loop < input.length; ++loop) {
                if (input[loop] == null || input[loop].getGeo() == null) continue;
                for (SimpleElement element : input[loop].getGeo()) {
                    GeoResource geo = new GeoResource(element);
                    this.addGeo(this.createGeoCluster(input[loop], geo));
                }
            }
        }
    }

    public void buildGeoClusters(RSS input) {
        this.clearClusters();
        if (input.getItems() != null) {
            for (RSSItem item : input.getItems()) {
                ArrayList geos = item.getElements("emm:georss");
                if (geos == null) continue;
                for (SimpleElement element : geos) {
                    GeoResource geo = new GeoResource(element);
                    this.addGeo(this.createGeoCluster(item, geo, input.getTitle()));
                }
            }
        }
    }

    public void clearClusters() {
        if (this.clusters != null) {
            this.clusters.clear();
        }
        this.clusters = new HashMap<Long, PriorityQueue<GeoCluster>>();
        this.icons = new ArrayList();
    }

    private int getTotalSize(PriorityQueue<GeoCluster> queue) {
        int retval = 0;
        for (GeoCluster cluster : queue) {
            retval += cluster.getSize();
        }
        return retval;
    }

    private void addGeo(GeoCluster cluster) {
        PriorityQueue<GeoCluster> found = this.clusters.get(cluster.getLatLon().gid);
        if (found == null) {
            found = new PriorityQueue(5);
            this.clusters.put(cluster.getLatLon().gid, found);
        }
        if (found.contains(cluster)) {
            found.remove(cluster);
        }
        found.add(cluster);
        if (!this.icons.contains(cluster.getIcon())) {
            this.icons.add(cluster.getIcon());
        }
    }

    public void expandStyles(Template tplate, String lang) {
        tplate.clearMacro("style");
        for (String icon : this.icons) {
            tplate.setParameter("icon", icon);
            tplate.setParameter("lang", lang);
            tplate.setParameter("scale", Double.toString(1.5));
            tplate.expandMacro("style");
        }
    }

    protected void expandCluster(PriorityQueue<GeoCluster> queue, Template tplate) throws IOException {
        Iterator<GeoCluster> iter = queue.iterator();
        if (iter.hasNext()) {
            GeoCluster cluster = iter.next();
            String clusid = Long.toString(cluster.getID());
            int qsize = this.getTotalSize(queue);
            for (String key : this.global.keySet()) {
                this.template.setParameter(key, this.global.get(key));
            }
            tplate.setParameter("clustermetadesc", "");
            tplate.setParameter("clust", clusid);
            tplate.setParameter("clustertotalsize", Integer.toString(this.getSize(queue)));
            cluster.toXMLCluster(tplate, queue.size(), qsize);
            while (iter.hasNext()) {
                cluster = iter.next();
                cluster.toXML(tplate, "item");
                tplate.expandMacro("item");
            }
            tplate.expandMacro("cluster");
        }
        this.template.clearMacro("item");
    }

    protected void expandTour(PriorityQueue<GeoCluster> queue, Template tplate) throws IOException {
        Iterator<GeoCluster> iter = queue.iterator();
        if (iter.hasNext()) {
            GeoCluster cluster = iter.next();
            String clusid = Long.toString(cluster.getID());
            int qsize = this.getTotalSize(queue);
            tplate.setParameter("clust", clusid);
            tplate.setParameter("clustertotalsize", Integer.toString(this.getSize(queue)));
            cluster.toXMLCluster(tplate, queue.size(), qsize);
            tplate.expandMacro("tour");
        }
    }

    private String getLanguage() {
        String lang = null;
        Iterator<PriorityQueue<GeoCluster>> iter = this.clusters.values().iterator();
        while (lang == null && iter.hasNext()) {
            PriorityQueue<GeoCluster> queue = iter.next();
            if (queue.size() <= 0) continue;
            lang = queue.peek().language;
        }
        if (lang == null) {
            lang = "en";
        }
        return lang;
    }

    public void toXML(Writer writer) throws Exception {
        if (this.template == null) {
            throw new NullPointerException("Template is null");
        }
        for (String key : this.global.keySet()) {
            this.template.setParameter(key, this.global.get(key));
        }
        if (this.clusters != null && this.clusters.size() > 0) {
            this.expandStyles(this.template, this.getLanguage());
            Vector<PriorityQueue<GeoCluster>> list = new Vector<PriorityQueue<GeoCluster>>(this.clusters.size());
            for (PriorityQueue<GeoCluster> queue : this.clusters.values()) {
                this.addToList(queue, list);
            }
            for (PriorityQueue<GeoCluster> queue : list) {
                this.expandCluster(queue, this.template);
            }
            if (this.template.getMarcoNames().contains("tour")) {
                int count = 0;
                for (PriorityQueue<GeoCluster> queue : list) {
                    this.expandTour(queue, this.template);
                    if (count == 20) break;
                    ++count;
                }
            }
        }
        writer.write(this.template.toString());
        writer.flush();
        this.template.clearMacro("cluster");
        if (this.template.getMarcoNames().contains("tour")) {
            this.template.clearMacro("tour");
        }
    }

    private void addToList(PriorityQueue<GeoCluster> q, Vector<PriorityQueue<GeoCluster>> list) {
        Iterator<PriorityQueue<GeoCluster>> iter = list.iterator();
        int loop = 0;
        boolean found = false;
        int qsize = this.getSize(q);
        while (iter.hasNext() && !found) {
            PriorityQueue<GeoCluster> test = iter.next();
            if (qsize > this.getSize(test)) {
                found = true;
                continue;
            }
            ++loop;
        }
        list.add(loop, q);
    }

    public void setClusters(Map<Long, PriorityQueue<GeoCluster>> newclusters) {
        if (this.clusters != null) {
            this.clearClusters();
        }
        this.clusters = newclusters;
    }

    private GeoCluster createGeoCluster(RTNClusterData data, GeoResource geo) {
        ArrayList eve = data.getEvents();
        if (eve != null && eve.size() > 0) {
            return new GeoEvent(data, geo, false);
        }
        return new GeoCluster(data, geo);
    }

    private GeoCluster createGeoCluster(RTNClusterInfo data, GeoResource geo) {
        ArrayList eve = data.getEvents();
        if (eve != null && eve.size() > 0) {
            return new GeoEvent(data, geo, false);
        }
        return new GeoCluster(data, geo);
    }

    private GeoCluster createGeoCluster(RSSItem data, GeoResource geo, String id) {
        ArrayList eve = data.getElements("emm:event");
        if (eve != null && eve.size() > 0) {
            return new GeoEvent(data, geo, (SimpleElement)eve.get(0), false);
        }
        return new GeoCluster(data, geo, id);
    }

    private int getSize(PriorityQueue<GeoCluster> q) {
        int size = 0;
        for (GeoCluster c : q) {
            size += c.getSize();
        }
        return size;
    }

    public static void main(String[] args) throws Exception {
        Template temp = new Template();
        temp.parse(new File(args[0]));
        GeoFormatter form = new GeoFormatter();
        form.initTemplate(temp);
        form.setTemplateParameter("langtitle", "TEST RSS EMM Real Time News Article Geo-Located Clusters");
        form.setTemplateParameter("langdesc", "TEST RSS Descriptive section for press");
        form.setTemplateParameter("langhomeurl", "http://press.jrc.it");
        form.setTemplateParameter("langhomeapp", "/NewsBrief");
        form.setTemplateParameter("langedition", "alertedition");
        FileInputStream is = new FileInputStream(args[1] + ".rss");
        InputStreamReader r = new InputStreamReader((InputStream)is, "UTF-8");
        RSSParser parser = new RSSParser();
        RSS rss = parser.parse((Reader)r);
        form.buildGeoClusters(rss);
        OutputStreamWriter wri = new OutputStreamWriter((OutputStream)new FileOutputStream(args[0] + "rss.kml"), "UTF-8");
        form.toXML(wri);
        wri.flush();
        wri.close();
        temp.setParameter("langtitle", "EMM Real Time News Story Geo-Located Clusters");
        temp.setParameter("langdesc", "EMM News Stories in EN Geo-located and grouped by geo location");
        temp.setParameter("langhomeurl", "http://press.jrc.it");
        temp.setParameter("langhomeapp", "/NewsBrief");
        temp.setParameter("langedition", "storyedition");
        is = new FileInputStream(args[1] + ".event");
        r = new InputStreamReader((InputStream)is, "UTF-8");
        rss = parser.parse((Reader)r);
        form.buildGeoClusters(rss);
        wri = new OutputStreamWriter((OutputStream)new FileOutputStream(args[0] + "event.kml"), "UTF-8");
        form.toXML(wri);
        wri.flush();
        wri.close();
        temp.setParameter("langtitle", "TEST RSS EMM Real Time News Article Geo-Located Clusters");
        temp.setParameter("langdesc", "TEST RSS Descriptive section for press");
        temp.setParameter("langhomeurl", "http://press.jrc.it");
        temp.setParameter("langhomeapp", "/NewsBrief");
        temp.setParameter("langedition", "alertedition");
        is = new FileInputStream(args[1] + ".cluster");
        r = new InputStreamReader((InputStream)is, "UTF-8");
        RTNClusterInfoParser p = new RTNClusterInfoParser();
        RTNClusterInfo[] ci = p.parse((Reader)r);
        form.buildGeoClusters(ci);
        wri = new OutputStreamWriter((OutputStream)new FileOutputStream(args[0] + "cluster.kml"), "UTF-8");
        form.toXML(wri);
        wri.flush();
        wri.close();
    }
}

