/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geoutils;

import it.jrc.emmutils.Template;
import it.jrc.geoutils.GeoUtils;
import it.jrc.rss.SimpleElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoResource {
    public long gid;
    public String name;
    public double lat;
    public double lon;
    public int cls = -1;
    public HashSet<Integer> lang = new HashSet();
    public int oldlang = -1;
    public int count = 1;
    public String match;
    public String position;
    public String cposition;
    public String wordlen;
    public double score;
    public int wpos = 50000000;
    public int cpos = 50000000;
    public int countryFound = 0;
    public int regionFound = 0;
    public int provinceFound = 0;
    public boolean hasPrefix = false;
    public String prefix = null;
    public ArrayList<String> loc_rel;
    public ArrayList<Boolean> fromExpress;
    public ArrayList<HashMap<String, Object>> others;
    public int internalCount = -1;
    public boolean adjective = false;
    private String iso;

    public GeoResource() {
    }

    public GeoResource(String nm) {
        this.name = nm;
        this.position = null;
        this.match = "";
    }

    public GeoResource(SimpleElement elem) {
        this.name = elem.getAttributeValue("name");
        try {
            this.gid = Long.parseLong(elem.getAttributeValue("id"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lat = Double.parseDouble(elem.getAttributeValue("lat"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lon = Double.parseDouble(elem.getAttributeValue("lon"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.count = Integer.parseInt(elem.getAttributeValue("count"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.position = elem.getAttributeValue("wordpos");
        try {
            this.cls = Integer.parseInt(elem.getAttributeValue("class"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.match = elem.getValue();
        this.iso = elem.getAttributeValue("iso");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoResource(String res, String splitter, HashMap<String, Integer> langmap) throws Exception {
        res = GeoResource.transformXmlEntities(res);
        String[] strings = res.split(splitter);
        this.position = null;
        this.name = strings[1].trim().replaceAll("\\s", "+");
        boolean len = true;
        this.gid = Long.parseLong(strings[0]);
        if (this.gid < 0L) {
            this.adjective = true;
        }
        if (strings.length > 4) {
            this.lat = Double.parseDouble(strings[2]);
            this.lon = Double.parseDouble(strings[3]);
            if (strings.length > 5) {
                if (!"".equals(strings[4])) {
                    this.cls = Integer.parseInt(strings[4]);
                }
                if (!langmap.containsKey(strings[5])) throw new RuntimeException("WARNING can't find language : " + strings[5]);
                if (strings.length >= 6 && strings[5] != null && langmap.containsKey(strings[5])) {
                    this.lang.add(langmap.get(strings[5]));
                    return;
                } else {
                    this.lang.add(-1);
                }
                return;
            } else {
                this.cls = 0;
                this.lang.clear();
            }
            return;
        } else {
            this.lat = 0.0;
            this.lon = 0.0;
            this.cls = 0;
            this.lang.clear();
        }
    }

    public boolean isCaps() {
        return this.match != null ? this.match.equals(this.match.toUpperCase()) : false;
    }

    public void addMatch(String m, int pos, int cp, boolean verbose) {
        this.addMatch(m, pos);
        if (verbose) {
            if (cp < this.cpos) {
                this.cpos = cp;
            }
            this.cposition = this.cposition == null ? Integer.toString(cp) : this.cposition + "," + Integer.toString(cp);
        } else {
            this.wordlen = null;
        }
    }

    public void addMatch(String m, int pos) {
        this.match = m;
        if (pos < this.wpos) {
            this.wpos = pos;
        }
        this.position = this.position == null ? Integer.toString(pos) : this.position + "," + Integer.toString(pos);
        this.wordlen = this.wordlen == null ? Integer.toString(m.length()) : this.wordlen + "," + Integer.toString(m.length());
    }

    private static void padBuff(int len, StringBuffer sb) {
        for (int loop = 0; loop < len; ++loop) {
            sb.append("0");
        }
    }

    public String toHexString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(GeoUtils.longHexChars(this.gid));
        long fval = Double.doubleToLongBits(this.lat);
        sbuf.append(GeoUtils.longHexChars(fval));
        fval = Double.doubleToLongBits(this.lon);
        sbuf.append(GeoUtils.longHexChars(fval));
        sbuf.append(GeoUtils.intHexChars(this.cls));
        if (this.lang.size() == 1) {
            sbuf.append(GeoUtils.intHexChars(this.lang.iterator().next()));
        } else if (this.lang.size() == 0) {
            sbuf.append(GeoUtils.intHexChars(-1));
        } else {
            throw new RuntimeException("Can't return multiple languages.... yet " + this.lang);
        }
        return sbuf.toString();
    }

    public static GeoResource parseString(String nm, String match, int pos, int cp, String pattern, boolean verbose) {
        GeoResource gr = GeoResource.parseString(nm, match, pos, pattern);
        gr.position = null;
        gr.wordlen = null;
        gr.wpos = 500000;
        gr.addMatch(match, pos, cp, verbose);
        if (!verbose) {
            gr.wordlen = null;
        }
        return gr;
    }

    public static GeoResource parseString(String nm, String match, int pos, String pattern) {
        GeoResource gr = new GeoResource(nm);
        gr.addMatch(match, pos);
        try {
            int i = 0;
            gr.gid = GeoUtils.readLong(pattern.substring(i).toCharArray());
            gr.lat = Double.longBitsToDouble(GeoUtils.readLong(pattern.substring(i += 8).toCharArray()));
            gr.lon = Double.longBitsToDouble(GeoUtils.readLong(pattern.substring(i += 8).toCharArray()));
            gr.cls = GeoUtils.readInt(pattern.substring(i += 8).toCharArray());
            gr.lang.add(GeoUtils.readInt(pattern.substring(i += 4).toCharArray()));
        }
        catch (Exception e) {
            String message = "on to parse:" + pattern;
        }
        return gr;
    }

    public static String parsePattern(String pattern) {
        String ret = null;
        try {
            int i = 0;
            long gid = GeoUtils.readLong(pattern.substring(i).toCharArray());
            double lat = Double.longBitsToDouble(GeoUtils.readLong(pattern.substring(i += 8).toCharArray()));
            double lon = Double.longBitsToDouble(GeoUtils.readLong(pattern.substring(i += 8).toCharArray()));
            int cls = GeoUtils.readInt(pattern.substring(i += 8).toCharArray());
            int lang = GeoUtils.readInt(pattern.substring(i += 4).toCharArray());
            ret = "gid: " + gid + " cls: " + cls + " lang:" + lang;
        }
        catch (Exception e) {
            String message = "on to parse:" + pattern;
        }
        return ret;
    }

    private static String transformXmlEntities(String pattern) {
        if (pattern.matches(".*&#[0-9]{4,4};.*")) {
            Matcher mat = Pattern.compile("(&#([0-9]{4,4});)").matcher(pattern);
            while (mat.find()) {
                String myreg = "&#" + mat.group(2) + ";";
                String utf8char = "" + new Character((char)Integer.parseInt(mat.group(2), 16));
                pattern = pattern.replaceAll(myreg, utf8char);
            }
            return pattern;
        }
        return pattern;
    }

    public String hashID() {
        return Long.toString(this.gid) + "_" + Integer.toString(this.lang.iterator().next());
    }

    public SimpleElement asSimpleElement(String fullpath) {
        return this.asSimpleElement(fullpath, null);
    }

    public SimpleElement asSimpleElement(String fullpath, String withIso) {
        SimpleElement element = this.asSimpleElement(new SimpleElement("emm:georss"));
        element.setAttribute("name", fullpath);
        if (withIso != null && !"".equals(withIso)) {
            element.addAttribute("iso", withIso);
        }
        if (this.cposition != null) {
            element.addAttribute("charpos", this.cposition);
        }
        if (this.wordlen != null) {
            element.addAttribute("wordlen", this.wordlen);
        }
        element.setValue(this.match);
        return element;
    }

    public SimpleElement asSimpleElement(SimpleElement elem) {
        elem.addAttribute("name", this.name);
        elem.addAttribute("id", Long.toString(this.gid));
        elem.addAttribute("lat", Double.toString(this.lat));
        elem.addAttribute("lon", Double.toString(this.lon));
        elem.addAttribute("count", Integer.toString(this.internalCount));
        elem.addAttribute("pos", this.cposition);
        elem.addAttribute("class", Integer.toString(this.cls));
        elem.setValue(this.match);
        return elem;
    }

    public SimpleElement asSimpleElement() {
        return this.asSimpleElement(false, null);
    }

    public SimpleElement asSimpleElement(boolean withIso, String iso) {
        SimpleElement element = new SimpleElement("emm:georss");
        element.addAttribute("name", this.name);
        element.addAttribute("id", Long.toString(this.gid));
        element.addAttribute("lat", Double.toString(this.lat));
        element.addAttribute("lon", Double.toString(this.lon));
        element.addAttribute("count", Integer.toString(this.internalCount));
        element.addAttribute("pos", this.cposition);
        element.addAttribute("class", Integer.toString(this.cls));
        if (iso != null && !"".equals(iso)) {
            element.addAttribute("iso", iso);
        }
        if (this.cposition != null) {
            element.addAttribute("charpos", this.cposition);
        }
        if (this.wordlen != null) {
            element.addAttribute("wordlen", this.wordlen);
        }
        element.setValue(this.match);
        return element;
    }

    protected Object clone() throws CloneNotSupportedException {
        GeoResource gr = (GeoResource)super.clone();
        gr.name = this.name;
        gr.count = this.count;
        gr.lat = this.lat;
        gr.lon = this.lon;
        gr.gid = this.gid;
        gr.cls = this.cls;
        gr.lang = this.lang;
        gr.match = this.match;
        gr.position = this.position;
        gr.cposition = this.cposition;
        gr.wordlen = this.wordlen;
        gr.wpos = this.wpos;
        gr.cpos = this.cpos;
        gr.countryFound = this.countryFound;
        gr.regionFound = this.regionFound;
        gr.provinceFound = this.provinceFound;
        return gr;
    }

    public String getCleanName() {
        return this.name.replaceAll("\\+", " ");
    }

    public void toXML(Template template) throws IOException {
        template.setParameter("emmgeo", Long.toString(this.gid));
        template.setParameter("emmgeopath", this.name.replace(':', ','));
        template.setParameter("emmgeolat", Double.toString(this.lat));
        double lat2 = this.lat + 2.0;
        template.setParameter("emmgeolatp2", Double.toString(lat2));
        template.setParameter("emmgeolon", Double.toString(this.lon));
        template.setParameter("emmgeoname", this.match != null ? this.match : this.name.split(":")[0]);
    }

    public String toString() {
        return this.getCleanName() + "(" + this.gid + "," + this.cls + "," + this.lang + ")";
    }

    public int hashCode() {
        return this.hashID().hashCode();
    }

    public boolean hasDefaultLang() {
        return this.lang.contains(-1) || this.lang.contains(-3) || this.lang.contains(-2);
    }

    public boolean hasABetterLanguage(GeoResource other) {
        int otherMin;
        int thisMin = GeoResource.getMinimum(this.lang);
        return thisMin < (otherMin = GeoResource.getMinimum(other.lang));
    }

    private static int getMinimum(HashSet<Integer> langs) {
        int ret = Integer.MAX_VALUE;
        for (Integer lang : langs) {
            ret = Math.min(ret, lang);
        }
        return ret;
    }

    public SimpleElement asSimpleElementForCluster() {
        SimpleElement element = new SimpleElement("emm:georss");
        element.addAttribute("name", this.name);
        element.addAttribute("id", Long.toString(this.gid));
        element.addAttribute("lat", Double.toString(this.lat));
        element.addAttribute("lon", Double.toString(this.lon));
        element.addAttribute("class", Integer.toString(this.cls));
        if (this.iso != null && !"".equals(this.iso)) {
            element.addAttribute("iso", this.iso);
        }
        element.setValue(this.match);
        return element;
    }
}

