/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.geoutils;

import it.jrc.geoutils.GeoResource;
import it.jrc.rss.RSSItem;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoUtils {
    static Logger logger = Logger.getLogger((String)GeoUtils.class.getName());

    public static ArrayList<SimpleElement> disambiguateGeoCluster(Collection<RSSItem> clusterItems) {
        ArrayList<RSSItem> items = new ArrayList<RSSItem>(clusterItems.size());
        for (RSSItem item : clusterItems) {
            if (item.getAttributeValue("type") != null && item.getAttributeValue("type").equals("linked")) continue;
            items.add(item);
        }
        ArrayList<SimpleElement> geos = GeoUtils.disambiguateGeoItems(items);
        if (geos.size() == 0) {
            items.clear();
            for (RSSItem rtnitem : clusterItems) {
                items.add(rtnitem);
            }
            geos = GeoUtils.disambiguateGeoItems(items);
        }
        return geos;
    }

    public static ArrayList<SimpleElement> disambiguateGeoItems(Collection<RSSItem> items) {
        ArrayList elems;
        ArrayList<SimpleElement> retval = new ArrayList<SimpleElement>(10);
        ArrayList<GeoResource> geos = new ArrayList<GeoResource>(items.size());
        ArrayList<String> entities = new ArrayList<String>(30);
        Date firstDate = new Date();
        Date lastDate = new Date();
        lastDate.setTime(0L);
        for (RSSItem item : items) {
            Date testdate = item.getDate();
            if (testdate.before(firstDate)) {
                firstDate = testdate;
            }
            if (!testdate.after(lastDate)) continue;
            lastDate = testdate;
        }
        long t1 = firstDate.getTime();
        long idelta = lastDate.getTime() - t1;
        if (idelta == 0L) {
            idelta = 1L;
        }
        double delta = (double)idelta * 1.0;
        logger.debug((Object)("Disambiguing " + items.size() + " elements."));
        String longish2 = "";
        for (RSSItem item : items) {
            elems = item.getElements("emm:georss");
            if (elems == null) continue;
            for (SimpleElement elem : elems) {
                longish2 = longish2 + elem.getAttributeValue("name") + " \n";
            }
        }
        logger.debug((Object)("Disambiguing " + items.size() + " elements. " + longish2));
        logger.debug((Object)("First Date : " + firstDate));
        logger.debug((Object)("Last  Date : " + lastDate));
        for (RSSItem item : items) {
            elems = item.getElements("emm:georss");
            double score = (double)(item.getDate().getTime() - t1) / delta;
            logger.debug((Object)("Article date : " + item.getDate() + " score(" + score + ")"));
            if (elems != null) {
                for (SimpleElement elem : elems) {
                    logger.debug((Object)("  Processing : " + elem));
                    GeoResource newgr = new GeoResource(elem);
                    newgr.score = score;
                    newgr.count = 1;
                    boolean found = false;
                    Iterator<GeoResource> iter = geos.iterator();
                    while (!found && iter.hasNext()) {
                        GeoResource gr = iter.next();
                        logger.debug((Object)("          looping on : " + gr + "  geos now has " + geos.size() + " elements"));
                        if (gr.gid != newgr.gid && !GeoUtils.contains(gr, newgr)) continue;
                        ++gr.count;
                        gr.score += newgr.score;
                        logger.debug((Object)("   Found: " + gr.score + " added (" + newgr.score + ")"));
                        found = true;
                    }
                    if (found) continue;
                    geos.add(newgr);
                }
            }
            elems = item.getElements("emm:entity");
            logger.debug((Object)("Disambiguating on " + (elems == null ? 0 : elems.size()) + " Entities"));
            if (elems == null) continue;
            for (SimpleElement elem : elems) {
                boolean found = true;
                Iterator<String> iter = entities.iterator();
                String elemname = elem.getValue();
                String titledesc = item.getTitle() + " " + item.getDescription();
                if (titledesc.contains(elemname)) {
                    found = false;
                    while (!found && iter.hasNext()) {
                        String ename = iter.next();
                        if (!ename.equals(elemname)) continue;
                        found = true;
                    }
                }
                if (found) continue;
                entities.add(elemname);
            }
        }
        String longish = "";
        for (GeoResource ge : geos) {
            longish = longish + ge.getCleanName() + "' ";
        }
        logger.debug((Object)("Entities found : " + entities + " \n\tbefore remove : " + longish));
        GeoUtils.removeEntityFromGeo(entities, geos, true);
        logger.debug((Object)("-----After remove : " + geos.size()));
        for (GeoResource resource : geos) {
            logger.debug((Object)("\t\t\t" + resource.getCleanName()));
        }
        for (GeoResource res : geos) {
            logger.debug((Object)("STEP 3 " + res.getCleanName() + "  " + res.score));
        }
        GeoUtils.capScores(geos);
        for (GeoResource res : geos) {
            logger.debug((Object)("\tSTEP 3b " + res.getCleanName() + "  " + res.score));
        }
        double max = 0.0;
        ArrayList<GeoResource> topScores = new ArrayList<GeoResource>(geos.size());
        for (GeoResource gr : geos) {
            if (gr.score > max) {
                max = gr.score;
                topScores.clear();
                topScores.add(gr);
                continue;
            }
            if (gr.score != max) continue;
            topScores.add(gr);
        }
        for (GeoResource res : topScores) {
            logger.debug((Object)("TOP SCORES " + res.getCleanName() + "  " + res.score + "  " + res + res.asSimpleElementForCluster()));
        }
        if (topScores.size() > 1 && GeoUtils.isRegion(((GeoResource)topScores.get((int)0)).gid) && ((GeoResource)topScores.get((int)0)).match.equals(((GeoResource)topScores.get((int)1)).match)) {
            return retval;
        }
        for (GeoResource gr : topScores) {
            retval.add(gr.asSimpleElementForCluster());
        }
        return retval;
    }

    private static boolean contains(GeoResource gr, GeoResource newgr) {
        if (GeoUtils.isCountry(gr.gid) && GeoUtils.inCountry(newgr.gid, gr.gid)) {
            logger.debug((Object)("\t\t\t\t" + gr.getCleanName() + " is a COUNTRY and contains: " + newgr.getCleanName()));
            return true;
        }
        if (GeoUtils.isRegion(gr.gid) && GeoUtils.inRegion(newgr.gid, gr.gid)) {
            logger.debug((Object)("\t\t\t\t" + gr.getCleanName() + " is a REGION and contains: " + newgr.getCleanName()));
            return true;
        }
        if (GeoUtils.isProvince(gr.gid) && GeoUtils.inProvince(newgr.gid, gr.gid)) {
            logger.debug((Object)("\t\t\t\t" + gr.getCleanName() + " is a PROVINCE and contains: " + newgr.getCleanName()));
            return true;
        }
        return false;
    }

    public static void capScores(ArrayList<GeoResource> places) {
        for (GeoResource gr : places) {
            for (GeoResource gr2 : places) {
                if (gr2.gid == gr.gid) continue;
                if (GeoUtils.isCountry(gr.gid) && !GeoUtils.isCountry(gr2.gid) && GeoUtils.sameCountry(gr.gid, gr2.gid)) {
                    gr2.countryFound = gr.count;
                    gr2.count += gr.count;
                    gr2.score += gr.score;
                    logger.debug((Object)("\t Setting score of " + gr2.getCleanName() + " to : " + gr2.score));
                    continue;
                }
                if (!GeoUtils.sameRegion(gr.gid, gr2.gid) || gr2.cls <= gr.cls || !(gr2.score < gr.score)) continue;
                gr2.count += gr.count;
                double gs = gr2.score;
                gr2.score = gr.score;
                gr.score = gs;
                logger.debug((Object)("\t Swapping the score of " + gr.getCleanName() + " " + gr2.getCleanName() + " (" + gr.score + "," + gr2.score + ")"));
            }
        }
    }

    public static void handleScores(ArrayList<GeoResource> geos, int max) {
        if (max == 1 && geos.size() == 1) {
            GeoResource gr = geos.get(0);
            if (gr.cls > 3) {
                geos.remove(0);
            }
        }
    }

    public static ArrayList<GeoResource> removeEntityFromGeo(ArrayList<String> entities, ArrayList<GeoResource> geos, boolean doit) {
        Iterator<GeoResource> iter = geos.iterator();
        block0: while (iter.hasNext()) {
            GeoResource gr = iter.next();
            String[] val = gr.name.split(":");
            if (gr.count >= 10) continue;
            for (int loop = 0; loop < val.length - 2; ++loop) {
                if (val[loop].length() <= 1 || !GeoUtils.listContains(entities, val[loop], doit)) continue;
                logger.debug((Object)("\t\t\tRemoving: " + gr.getCleanName() + " " + val[loop]));
                iter.remove();
                continue block0;
            }
        }
        return geos;
    }

    public static ArrayList<SimpleElement> removeEntityFromGeo(ArrayList<SimpleElement> entities, ArrayList<SimpleElement> geos) {
        if (geos == null) {
            return null;
        }
        if (entities == null) {
            return geos;
        }
        ArrayList<SimpleElement> retlist = new ArrayList<SimpleElement>(geos.size());
        for (SimpleElement elem : geos) {
            String geoname = elem.getValue();
            if (geoname == null || geoname.length() == 0) {
                geoname = elem.getAttributeValue("name").split(":")[0];
            }
            if (GeoUtils.listContains(entities, geoname)) continue;
            retlist.add(elem);
        }
        return retlist;
    }

    public static boolean listContainsExactly(ArrayList<SimpleElement> entities, String name) {
        if (entities == null || name == null) {
            return false;
        }
        int len = name.length();
        for (SimpleElement elem : entities) {
            String ename = elem.getValue().toLowerCase();
            int elen = ename.length();
            if (len == elen && name.equalsIgnoreCase(ename)) {
                return true;
            }
            if (elen <= len || !Pattern.compile("\\b(" + name.toLowerCase() + ")\\b").matcher(ename.toLowerCase()).find()) continue;
            return true;
        }
        return false;
    }

    public static boolean listContains(ArrayList<SimpleElement> entities, String name) {
        if (entities == null || name == null) {
            return false;
        }
        int len = name.length();
        for (SimpleElement elem : entities) {
            String ename = elem.getValue().toLowerCase();
            int elen = ename.length();
            if (len == elen && name.equalsIgnoreCase(ename)) {
                return true;
            }
            if (elen <= len || !ename.toLowerCase().contains(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean listContains(ArrayList<String> entities, String name, boolean doit) {
        if (entities == null || name == null) {
            return false;
        }
        int len = name.length();
        for (String elem : entities) {
            int elen = elem.length();
            if (len == elen && name.equalsIgnoreCase(elem)) {
                return true;
            }
            if (elen <= len || !elem.toLowerCase().contains(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static char[] longHexChars(long val) {
        char[] chars = new char[8];
        for (int i = 0; i < 8; ++i) {
            chars[i] = (char)(val & 0xFFL);
            val &= 0xFFFFFFFFFFFFFF00L;
            val >>= 8;
        }
        return chars;
    }

    public static char[] intHexChars(int val) {
        char[] chars = new char[4];
        for (int i = 0; i < 4; ++i) {
            chars[i] = (char)(val & 0xFF);
            val &= 0xFFFFFF00;
            val >>= 8;
        }
        return chars;
    }

    public static long readLong(char[] toread) {
        long val = 0L;
        for (int i = 0; i < 8; ++i) {
            val += (long)toread[i] << 8 * i;
        }
        return val;
    }

    public static int readInt(char[] toread) {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val += toread[i] << 8 * i;
        }
        return val;
    }

    public static long getCountryId(long id) {
        return id & 0x1FFL;
    }

    public static long getRegionId(long id) {
        return id & 0xFFFFL;
    }

    public static long getProvinceId(long id) {
        return id & 0xFFFFFFL;
    }

    public static boolean isProvince(long id) {
        return id > 65535L && id <= 0xFFFFFFL;
    }

    public static boolean isRegion(long id) {
        return id > 511L && id <= 65535L;
    }

    public static boolean isCountry(long id) {
        return id <= 511L;
    }

    public static boolean inCountry(long id, long idcountry) {
        return (id & 0x1FFL) == idcountry;
    }

    public static boolean inRegion(long id, long idregion) {
        return (id & 0xFFFFL) == idregion;
    }

    public static boolean inProvince(long id, long idregion) {
        return (id & 0xFFFFFFL) == idregion;
    }

    public static boolean sameProvince(long id, long id2) {
        return (id & 0xFFFFFFL) == (id2 & 0xFFFFFFL);
    }

    public static boolean sameRegion(long id, long id2) {
        return (id & 0xFFFFL) == (id2 & 0xFFFFL);
    }

    public static boolean sameCountry(long id, long id2) {
        return (id & 0x1FFL) == (id2 & 0x1FFL);
    }
}

