/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.emmtools;

import it.jrc.dispatcher.Dispatcher;
import it.jrc.emmtools.LanguageMatch;
import it.jrc.emmtools.ProcessRSS;
import it.jrc.emmutils.FileExtFilter;
import it.jrc.emmutils.HTTPStream;
import it.jrc.matcher.MatchWords;
import it.jrc.scheduler.CachedJob;
import it.jrc.scheduler.Job;
import it.jrc.scheduler.Scheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageDetector
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger((String)"it.jrc.emmtools.LanguageDetector");
    private MatchWords matchWords = MatchWords.getInstance((String)"LanguageDetector");
    private ArrayList<String> languages;
    private Scheduler scheduler;
    private static Dispatcher dispatcher;
    private String jobQ = null;
    private String languageDefDir;
    private String resourceURL;
    private Timer resourceTimer;
    private ArrayList<ProcessRSS> threadPool;
    private int nThreads;
    private String servletName;

    public void init(ServletConfig paramServletConfig) throws ServletException {
        super.init(paramServletConfig);
        this.servletName = paramServletConfig.getServletName();
        String str1 = paramServletConfig.getInitParameter("qDef");
        if (str1 == null || str1.equals("")) {
            str1 = paramServletConfig.getServletContext().getRealPath("/queues.xml");
        }
        logger.info("queue definition file lives at:" + str1);
        this.nThreads = 4;
        String str2 = paramServletConfig.getInitParameter("nThreads");
        if (str2 != null && !str2.equals("")) {
            this.nThreads = new Integer(str2);
        }
        logger.info("the number of worker threads: " + this.nThreads);
        this.threadPool = new ArrayList();
        this.jobQ = paramServletConfig.getInitParameter("jobQ");
        if (this.jobQ == null || this.jobQ.equals("")) {
            this.jobQ = paramServletConfig.getServletContext().getRealPath("/jobs");
        }
        logger.info("jobs live in:" + this.jobQ);
        dispatcher = new Dispatcher();
        try {
            dispatcher.initQs(str1, paramServletConfig.getServletContext().getRealPath("/Qs/"));
        }
        catch (Exception localException1) {
            logger.error("could not init client qs", (Throwable)localException1);
            throw new ServletException("could not init client qs");
        }
        this.scheduler = new Scheduler(this.jobQ);
        this.languageDefDir = paramServletConfig.getServletContext().getRealPath("/" + paramServletConfig.getInitParameter("languageDefDir"));
        logger.info("language definitions live in:" + this.languageDefDir);
        this.resourceURL = paramServletConfig.getInitParameter("resourceURL");
        if (this.resourceURL == null || this.resourceURL.equals("")) {
            this.resourceURL = null;
            logger.warn("no resources specified, will NOT update automatically");
            try {
                this.initLanguages(this.languageDefDir);
            }
            catch (Exception localException2) {
                logger.error("could not init languages", (Throwable)localException2);
                throw new ServletException("could not init languages");
            }
            this.initProcesses();
        } else {
            logger.info("resource updates live at:" + this.resourceURL);
            this.resourceTimer = new Timer(true);
            GetResourceZip localGetResourceZip = new GetResourceZip();
            this.resourceTimer.scheduleAtFixedRate((TimerTask)localGetResourceZip, 0L, 86400000L);
        }
        this.scheduler.start();
        logger.info("LanguageDetector Init succesful");
    }

    private void initProcesses() {
        for (int i = 0; i < this.nThreads; ++i) {
            ProcessRSS localProcessRSS = new ProcessRSS(this.servletName + ":rss:" + i, this.scheduler, dispatcher, new LanguageMatch(this.languages));
            localProcessRSS.start();
            this.threadPool.add(localProcessRSS);
            logger.info("Started " + localProcessRSS.getName());
        }
    }

    private void initLanguages(String paramString) throws Exception {
        int i;
        Hashtable<String, StringBuilder> localHashtable = new Hashtable<String, StringBuilder>();
        this.languages = new ArrayList();
        File localFile = new File(paramString);
        File[] arrayOfFile = localFile.listFiles((FilenameFilter)new FileExtFilter(".def"));
        logger.info("found " + arrayOfFile.length + " languages in " + paramString);
        for (i = 0; i < arrayOfFile.length; ++i) {
            File localObject1 = arrayOfFile[i];
            int j = localObject1.getName().indexOf(".def");
            String localObject2 = localObject1.getName().substring(0, j);
            logger.info("reading words for " + localObject2);
            this.languages.add(localObject2);
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(localObject1), "utf-8"));
            String str2 = localBufferedReader.readLine();
            for (char c = '\u00c8'; str2 != null && c > '\u0000'; c = (char)(c - '\u0001')) {
                StringBuilder localStringBuilder = (StringBuilder)localHashtable.get(str2);
                if (localStringBuilder == null) {
                    localStringBuilder = new StringBuilder();
                    localStringBuilder.append('\u0000');
                }
                localStringBuilder.append((char)i).append(c);
                int m = localStringBuilder.charAt(0) + '\u0001';
                localStringBuilder.setCharAt(0, (char)m);
                localHashtable.put(str2, localStringBuilder);
                str2 = localBufferedReader.readLine();
            }
        }
        this.matchWords.init(localHashtable);
        for (i = 0; i < this.languages.size(); ++i) {
            logger.info("words used for " + this.languages.get(i));
            for (String str1 : localHashtable.keySet()) {
                StringBuilder localObject4 = (StringBuilder)localHashtable.get(str1);
                for (int k = 0; k < localObject4.charAt(0); ++k) {
                    if (localObject4.charAt(k * 2 + 1) != (char)i) continue;
                    logger.info(str1 + " : " + localObject4.charAt(k * 2 + 2));
                }
            }
        }
    }

    public void doPost(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) throws ServletException, IOException {
        String str1 = null;
        String str2 = null;
        str1 = paramHttpServletRequest.getParameter("id");
        str2 = paramHttpServletRequest.getParameter("xml");
        if (str1 != null && !str1.equals("")) {
            logger.info("received job for " + str1);
            CachedJob localCachedJob = CachedJob.makeJob((String)this.jobQ, (String)str1, (String)str2);
            int i = this.scheduler.schedule((Job)localCachedJob);
            paramHttpServletResponse.setStatus(200);
        } else {
            paramHttpServletResponse.setStatus(400);
        }
    }

    private void stopProcesses() {
        for (int i = 0; i < this.threadPool.size(); ++i) {
            try {
                ProcessRSS localProcessRSS = this.threadPool.get(i);
                logger.info("stopping " + localProcessRSS.getName());
                localProcessRSS.end();
                localProcessRSS = null;
                continue;
            }
            catch (Exception localException) {
                logger.warn("error stopping " + this.threadPool.get(i).getName(), (Throwable)localException);
            }
        }
    }

    public void destroy() {
        logger.info("LanguageDetector destroy");
        if (this.resourceTimer != null) {
            this.resourceTimer.cancel();
        }
        this.scheduler.destroy();
        dispatcher.destroy();
        this.stopProcesses();
        logger.info("LanguageDetector stopped");
    }

    private class GetResourceZip
    extends TimerTask {
        private GetResourceZip() {
        }

        @Override
        public void run() {
            try {
                ZipInputStream localZipInputStream = new ZipInputStream((InputStream)new HTTPStream(LanguageDetector.this.resourceURL));
                ZipEntry localObject = localZipInputStream.getNextEntry();
                while (localObject != null && localObject.isDirectory()) {
                    String str1 = localObject.getName();
                    String str2 = str1.substring(0, str1.length() - 1);
                    ZipEntry localZipEntry = localZipInputStream.getNextEntry();
                    if (!localZipEntry.isDirectory()) {
                        File localFile = new File(LanguageDetector.this.languageDefDir + "/" + str2 + ".def");
                        FileOutputStream localFileOutputStream = new FileOutputStream(localFile);
                        int i = 16384;
                        byte[] arrayOfByte = new byte[i];
                        int j = localZipInputStream.read(arrayOfByte, 0, i);
                        while (j >= 0) {
                            localFileOutputStream.write(arrayOfByte, 0, j);
                            j = localZipInputStream.read(arrayOfByte, 0, i);
                        }
                        localFileOutputStream.flush();
                        localFileOutputStream.close();
                        localZipInputStream.closeEntry();
                        localObject = localZipInputStream.getNextEntry();
                        continue;
                    }
                    localObject = localZipEntry;
                }
            }
            catch (Exception localException1) {
                logger.error("could not produce language resource definitions", (Throwable)localException1);
            }
            try {
                LanguageDetector.this.stopProcesses();
                LanguageDetector.this.initLanguages(LanguageDetector.this.languageDefDir);
                LanguageDetector.this.initProcesses();
            }
            catch (Exception localException2) {
                logger.error("could not init languages", (Throwable)localException2);
            }
        }
    }
}

