/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.emmtools;

import it.jrc.emmtools.LanguageScore;
import it.jrc.matcher.MatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LanguageMatch
implements MatchResult {
    private static Logger logger = Logger.getLogger((String)"it.jrc.emmtools.LanguageMatch");
    private int wordCount;
    private ArrayList<String> languages;
    private int[] count;
    private int[] score;
    private int total;
    private int potentialMaxScore;

    public LanguageMatch(ArrayList<String> paramArrayList) {
        this.languages = paramArrayList;
    }

    public void init() {
        int j;
        int i = this.languages.size();
        this.count = new int[i];
        for (j = 0; j < this.count.length; ++j) {
            this.count[j] = 0;
        }
        this.score = new int[i];
        for (j = 0; j < this.score.length; ++j) {
            this.score[j] = 0;
        }
        this.total = 0;
        this.potentialMaxScore = 0;
    }

    public void addMatch(char[] paramArrayOfChar, int paramInt1, String paramString, int paramInt2, int paramInt3) {
        char c;
        int i = paramInt1 + 3;
        int j = paramArrayOfChar[i];
        int n = -1;
        for (int m = 0; m < j; ++m) {
            char i1;
            char n2 = paramArrayOfChar[++i];
            if ((i1 = paramArrayOfChar[++i]) > c) {
                c = i1;
            }
            char c2 = n2;
            this.count[c2] = this.count[c2] + 1;
            char c3 = n2;
            this.score[c3] = this.score[c3] + i1;
        }
        this.potentialMaxScore += c;
        ++this.total;
    }

    public void setWordCount(int paramInt) {
        this.wordCount = paramInt;
    }

    public LanguageScore[] getScores() {
        Object[] arrayOfLanguageScore = new LanguageScore[this.languages.size()];
        for (int i = 0; i < this.languages.size(); ++i) {
            arrayOfLanguageScore[i] = new LanguageScore();
            ((LanguageScore)arrayOfLanguageScore[i]).language = this.languages.get(i);
            ((LanguageScore)arrayOfLanguageScore[i]).score = this.count[i] > 0 ? (double)this.score[i] * 100.0 / (double)this.potentialMaxScore : 0.0;
        }
        Arrays.sort(arrayOfLanguageScore);
        return arrayOfLanguageScore;
    }

    public String getLanguage(String paramString) {
        int n;
        String str = null;
        if (this.wordCount == 0) {
            logger.error((Object)"no words matched.");
            return null;
        }
        double d = (double)this.total * 1.0 / (double)this.wordCount;
        int i = 0;
        int j = 0;
        int k = 0;
        int m = 0;
        if (this.total >= 5) {
            n = -1;
            for (int i1 = 0; i1 < this.languages.size(); ++i1) {
                m += this.score[i1];
                if (this.score[i1] > i) {
                    k = j;
                    j = i;
                    i = this.score[i1];
                    n = i1;
                    continue;
                }
                if (this.score[i1] > j) {
                    k = j;
                    j = this.score[i1];
                    continue;
                }
                if (this.score[i1] <= k) continue;
                k = this.score[i1];
            }
            if (i - (i + j + k) / 10 > j) {
                str = this.languages.get(n);
            }
        }
        if (str == null || !str.equals(paramString)) {
            logger.info((Object)("total hits: " + this.total + " words: " + this.wordCount + " s: " + d));
            logger.info((Object)("total score: " + m + " potential Max: " + this.potentialMaxScore + " maxScore: " + i + " max1: " + j + " max2: " + k));
            for (n = 0; n < this.languages.size(); ++n) {
                if (this.count[n] <= 0) continue;
                logger.info((Object)(this.languages.get(n) + " count: " + this.count[n] + "(" + (double)this.count[n] * 1.0 / (double)this.total + ")" + " score: " + this.score[n] + "(" + (double)this.score[n] * 100.0 / (double)this.potentialMaxScore + ")"));
            }
        }
        return str;
    }
}

