/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.emmcrawler;

import it.jrc.emmcrawler.Href;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class HrefManager {
    private static final boolean DEBUG = false;
    private HashMap<String, Href> done;
    private HashMap<String, Href> hrefs;
    private HashMap<Integer, ArrayList<String>> sorted;
    private int maxLevel;
    private static Logger logger = null;
    private Pattern followLinks;

    public HrefManager(ArrayList<String> urls, int lmax, String l) {
        if (logger == null) {
            logger = LogManager.getLogger((String)"it.jrc.emmcrawler.HrefManager");
        }
        logger.info("construct new HrefManager with maxLevel = " + lmax);
        this.done = new HashMap();
        this.hrefs = new HashMap();
        this.sorted = new HashMap();
        this.maxLevel = lmax;
        int i = 0;
        while (i < urls.size()) {
            String url = urls.get(i);
            Href href = new Href(url);
            href.title = "";
            href.confidence = 10;
            href.xhost = 0;
            href.type = 1;
            href.count = 0;
            this.hrefs.put(href.url, href);
            Integer level = new Integer(0);
            ArrayList<String> levelHrefs = new ArrayList<String>();
            this.sorted.put(level, levelHrefs);
            levelHrefs.add(href.url);
            logger.info("start at " + href.url);
            ++i;
        }
        if (l == null) {
            l = ".*";
        }
        this.followLinks = Pattern.compile(l, 2);
    }

    private void addHref(Href href) {
        if (!this.followLinks.matcher(href.url).matches()) {
            return;
        }
        Href h = this.hrefs.get(href.url);
        if (h == null) {
            logger.debug("adding " + href.url);
            this.hrefs.put(href.url, href);
            ArrayList<String> levelHrefs = this.sorted.get(href.level);
            if (levelHrefs == null) {
                levelHrefs = new ArrayList();
                this.sorted.put(href.level, levelHrefs);
            }
            levelHrefs.add(href.url);
        } else {
            String title = "";
            if (h.title != null) {
                title = h.title;
            }
            if (href.title != null && href.title.length() > title.length()) {
                title = href.title;
            }
            h.title = title;
            if (h.level > href.level) {
                h.level = href.level;
            }
            ++h.count;
        }
    }

    private void addRemote(Href href) {
    }

    public void add(ArrayList<Href> pageHrefs) {
        if (pageHrefs == null) {
            return;
        }
        int i = 0;
        while (i < pageHrefs.size()) {
            Href href = pageHrefs.get(i);
            Href h = this.done.get(href.url);
            if (h == null) {
                if ((this.maxLevel < 0 || href.level <= this.maxLevel) && href.confidence > 0) {
                    if (href.isLocal()) {
                        this.addHref(href);
                    } else if (href.isRemote()) {
                        this.addRemote(href);
                    }
                }
            } else {
                ++h.count;
            }
            ++i;
        }
    }

    public Href getNext() {
        return this.getNext(null);
    }

    public Href getNext(Href hrefDone) {
        logger.debug("hrefs to do " + this.hrefs.size());
        if (hrefDone != null) {
            this.done.put(hrefDone.url, hrefDone);
        }
        String sURL = null;
        int level = 0;
        while ((this.maxLevel < 0 || level <= this.maxLevel) && sURL == null && this.sorted.size() > 0) {
            ArrayList<String> levelHrefs = this.sorted.get(level);
            if (levelHrefs != null) {
                sURL = levelHrefs.remove(0);
                if (levelHrefs.size() == 0) {
                    this.sorted.remove(level);
                }
            }
            ++level;
        }
        if (sURL != null) {
            Href href = this.hrefs.remove(sURL);
            return href;
        }
        return null;
    }

    public HashMap<String, Href> getHrefs() {
        return this.done;
    }

    public void close() {
        this.done.clear();
        this.done = null;
        this.hrefs.clear();
        this.hrefs = null;
        this.sorted.clear();
        this.sorted = null;
    }
}

