/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler;

import it.jrc.osint.crawler.CrawlerService;
import it.jrc.osint.crawler.internal.CrawlerServiceImpl;
import it.jrc.osint.extract.text.TextExtractPlugin;
import it.jrc.osint.extract.text.TextExtractionService;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.net.ProxyServiceClient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CrawlerPlugin
extends Plugin {
    private static final Logger log = LogManager.getLogger((String)CrawlerPlugin.class.getName());
    public static final String PLUGIN_ID = "it.jrc.osint.crawler";
    private static CrawlerPlugin plugin;
    private CrawlerServiceImpl crawlerService;
    private ProxyServiceClient proxyServiceClient;
    private SearchService searchService;
    private EventBroker eventBroker;
    private TextExtractionService textExtractionService;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.eventBroker = new EventBroker(context);
        this.searchService = SearchPlugin.getSearchService();
        this.proxyServiceClient = new ProxyServiceClient(context);
        this.textExtractionService = TextExtractPlugin.getTextExtractionService();
        this.crawlerService = new CrawlerServiceImpl(this.eventBroker, this.proxyServiceClient, this.searchService);
        this.crawlerService.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.proxyServiceClient.stop();
        this.crawlerService.stop();
        plugin = null;
        super.stop(context);
    }

    public static CrawlerPlugin getPlugin() {
        return plugin;
    }

    public static CrawlerService getCrawlerService() {
        return CrawlerPlugin.getPlugin().crawlerService;
    }

    public static TextExtractionService getTextExtractionService() {
        return CrawlerPlugin.getPlugin().textExtractionService;
    }

    public static EventBroker getEventBroker() {
        return CrawlerPlugin.getPlugin().eventBroker;
    }

    private String getPluginBasePath() {
        URL filePath;
        block4: {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            if (bundle == null) {
                return null;
            }
            try {
                filePath = bundle.getEntry("/");
                if (filePath != null) break block4;
                return null;
            }
            catch (IOException e) {
                String message = "it.jrc.osint.crawler plugin and its resource dir not found  Exception: " + e.getMessage();
                log.error(message, (Throwable)e);
                return null;
            }
        }
        URL localPath = FileLocator.resolve((URL)filePath);
        File baseFolder = new File(FileLocator.toFileURL((URL)localPath).getFile());
        return baseFolder.getAbsolutePath();
    }

    private String getPhantomExecutableName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return "phantomjs.exe";
        }
        if (os.indexOf("mac") >= 0 || os.indexOf("linux") >= 0) {
            return "phantomjs";
        }
        throw new IllegalStateException("Unsupported OS detected");
    }

    private String getScriptBasePath() {
        return String.valueOf(this.getPluginBasePath()) + File.separator + "scripts";
    }

    private String getJsonTempBasePath() {
        return String.valueOf(this.getPluginBasePath()) + File.separator + "jsontemp";
    }
}

