/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.internal;

import it.jrc.emmcrawler.Crawler;
import it.jrc.osint.crawler.CrawlerPlugin;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.internal.URLBookmarkImpl;
import it.jrc.rss.RSSItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class BookmarkCrawler
extends Crawler {
    private IProgressMonitor monitor;
    private Map<String, URLBookmark> bookmarks = new HashMap<String, URLBookmark>();

    public BookmarkCrawler(ArrayList<String> sites, int maxDepth, int nWorkers, int randomDelay, IProgressMonitor monitor) {
        super(sites, maxDepth, null);
        this.monitor = monitor;
        this.setWorkers(nWorkers);
        this.setRandomDelay(randomDelay);
        this.setHtmlType("rss");
    }

    public List<URLBookmark> getBookmarks() {
        ArrayList<URLBookmark> resultingBookmarks = new ArrayList<URLBookmark>();
        resultingBookmarks.addAll(this.bookmarks.values());
        return resultingBookmarks;
    }

    @Override
    public void newItem(RSSItem item) {
        String url = item.getLink();
        if (!this.bookmarks.containsKey(url)) {
            URLBookmarkImpl newBookmark = new URLBookmarkImpl(item.getLink());
            newBookmark.setTitle(item.getTitle());
            newBookmark.setSearchEngine("HTTP Web Crawler");
            this.bookmarks.put(url, (URLBookmark)newBookmark);
        }
        if (this.monitor != null) {
            this.monitor.subTask(String.valueOf(this.bookmarks.size()) + " pages downloaded.");
            if (this.monitor.isCanceled()) {
                this.cancel();
            }
        }
    }

    @Override
    public void finished() {
    }

    @Override
    protected boolean canExtract(String contentType) {
        return CrawlerPlugin.getTextExtractionService().canExtract(contentType);
    }
}

