/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.internal;

import it.jrc.emmutils.HTTPStream;
import it.jrc.osint.crawler.CrawlerConfiguration;
import it.jrc.osint.crawler.CrawlerPlugin;
import it.jrc.osint.crawler.CrawlerService;
import it.jrc.osint.crawler.CrawlerServiceEvent;
import it.jrc.osint.crawler.internal.CrawlJob;
import it.jrc.osint.crawler.internal.CrawlerConfigurationImpl;
import it.jrc.osint.crawler.internal.CrawlerServiceEventImpl;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.util.io.PersistentMap;
import it.jrc.osint.util.io.TmpDirSupport;
import it.jrc.osint.util.net.ProxyData;
import it.jrc.osint.util.net.ProxyServiceClient;
import it.jrc.osint.workspace.CaseProject;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class CrawlerServiceImpl
implements CrawlerService {
    private static final Logger log = LogManager.getLogger((String)CrawlerServiceImpl.class.getName());
    private EventBroker eventBroker;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private ProxyServiceClient proxyServiceClient;
    private SearchService searchService;
    private TmpDirSupport tmpDirSupport = new TmpDirSupport();

    public CrawlerServiceImpl(EventBroker eventBroker, ProxyServiceClient proxyServiceClient, SearchService searchService) {
        this.proxyServiceClient = proxyServiceClient;
        this.searchService = searchService;
        this.eventBroker = eventBroker;
        this.eventBroker.register(new String[]{"osint/crawler/crawlFinished"}, this.topicEventListener);
    }

    public void start() {
        this.tmpDirSupport.init(CrawlerPlugin.getPlugin().getStateLocation().toFile());
    }

    public void stop() {
        if (this.eventBroker != null) {
            this.eventBroker.stop();
        }
        this.tmpDirSupport.cleanup();
    }

    @Override
    public void crawl(CrawlerConfiguration config, String operationName, CaseProject targetProject) {
        this.updateHttpStreamProxy();
        CrawlJob crawlJob = new CrawlJob("HTTP Crawler ", config, operationName, targetProject);
        crawlJob.addJobChangeListener((IJobChangeListener)new JobChangeListener());
        crawlJob.setUser(true);
        crawlJob.schedule();
    }

    private void fireCrawlerServiceEvent(CrawlerServiceEvent event) {
        CrawlerPlugin.getEventBroker().postEvent((SystemEvent)event);
    }

    @Override
    public CrawlerConfiguration loadConfiguration(InputStream in) {
        try {
            PersistentMap map = new PersistentMap("it.jrc.osint.contenttype.CrawlerConfig");
            boolean loadsuccess = map.load(in);
            if (!loadsuccess) {
                return null;
            }
            CrawlerConfigurationImpl crawlerConfigurationImpl = new CrawlerConfigurationImpl(map);
            return crawlerConfigurationImpl;
        }
        catch (Throwable t) {
            log.error("Failed to load crawler configuration", t);
        }
        finally {
            FileUtil.close((InputStream)in);
        }
        return null;
    }

    @Override
    public InputStream saveConfiguration(CrawlerConfiguration config) {
        Writer outWriter = null;
        try {
            CrawlerConfigurationImpl configImpl = (CrawlerConfigurationImpl)config;
            PersistentMap map = (PersistentMap)configImpl.getPersistenceObject();
            InputStream inputStream = map.save();
            return inputStream;
        }
        catch (Throwable t) {
            log.error("Failed to save crawler configuration", t);
            return null;
        }
        finally {
            FileUtil.close(outWriter);
        }
    }

    @Override
    public CrawlerConfiguration createConfiguration() {
        return new CrawlerConfigurationImpl();
    }

    private void updateHttpStreamProxy() {
        if (this.proxyServiceClient == null) {
            return;
        }
        if (this.proxyServiceClient.isProxyEnabled("HTTP")) {
            ProxyData pd = this.proxyServiceClient.getProxyData("HTTP");
            HTTPStream.setProxy((String)pd.getProxyHost(), (String)Integer.toString(pd.getProxyPort()), (String)pd.getNonProxiedHostsList(), (String)pd.getUserId(), (String)pd.getUserPassword());
        } else {
            HTTPStream.disableProxy();
        }
    }

    private void importBookmarks(String operationName, CaseProject targetProject, List<URLBookmark> bookmarks) {
        if (!bookmarks.isEmpty()) {
            this.searchService.getImporter().importBookmarks(operationName, targetProject, bookmarks);
        }
    }

    private class JobChangeListener
    extends JobChangeAdapter {
        public void done(IJobChangeEvent event) {
            super.done(event);
            CrawlJob job = (CrawlJob)event.getJob();
            CrawlerServiceEventImpl serviceEvent = new CrawlerServiceEventImpl("osint/crawler/crawlFinished");
            serviceEvent.setOperationName(job.getOperationName());
            serviceEvent.setOperationStatus(OperationStatus.OK_STATUS);
            serviceEvent.setBookmarks(job.getBookmarks());
            serviceEvent.setTargetProject(job.getTargetProject());
            CrawlerServiceImpl.this.fireCrawlerServiceEvent(serviceEvent);
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if ("osint/crawler/crawlFinished".equals(event.getTopic())) {
                CrawlerServiceEvent csEvent = (CrawlerServiceEvent)event;
                CrawlerServiceImpl.this.importBookmarks(csEvent.getOperationName(), csEvent.getTargetProject(), csEvent.getBookmarks());
            }
        }
    }
}

