/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.cmatcher.ui.views;

import it.jrc.osint.ResourceId;
import it.jrc.osint.cmatcher.ui.CmatcherUIPlugin;
import it.jrc.osint.cmatcher.ui.views.CategoryBrowserController;
import it.jrc.osint.cmatcher.ui.views.DocForTreeViewer;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import it.jrc.osint.util.ui.PartListenerAdapter;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class CategoryBrowserView
extends ViewPart {
    public static final String ID = "it.jrc.osint.cmatcher.ui.views.CategoryBrowserView";
    private static final Logger log = LogManager.getLogger((String)CategoryBrowserView.class.getName());
    private CategoryBrowserController controller = new CategoryBrowserController(this);
    private PartListenerImpl partListener;
    private Composite categoriesComposite;
    private Composite resultCatComposite;
    private Label activeConfigProjectLabel;
    private Combo selectCategoryCombo;
    private ComboViewer selectCategoryComboViewer;
    private Composite srtitlecomposite;
    private Label resultsLabel;
    private TreeViewer resultTreeViewer;

    public void createPartControl(Composite parent) {
        this.partListener = new PartListenerImpl();
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.categoriesComposite = new Composite(container, 0);
        this.categoriesComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.categoriesComposite.setLayout((Layout)new GridLayout(3, false));
        Label sourceConfigProjectLabel = new Label(this.categoriesComposite, 8);
        GridData gd_sourceConfigProjectLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_sourceConfigProjectLabel.horizontalIndent = 5;
        sourceConfigProjectLabel.setLayoutData((Object)gd_sourceConfigProjectLabel);
        sourceConfigProjectLabel.setSize(74, 15);
        sourceConfigProjectLabel.setText("Active Config Project:");
        this.activeConfigProjectLabel = new Label(this.categoriesComposite, 8);
        GridData gd_activeConfigProjectLabel = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_activeConfigProjectLabel.horizontalIndent = 5;
        this.activeConfigProjectLabel.setLayoutData((Object)gd_activeConfigProjectLabel);
        this.activeConfigProjectLabel.setSize(74, 15);
        this.activeConfigProjectLabel.setText("");
        Label selectCategoryLabel = new Label(this.categoriesComposite, 0);
        GridData gd_selectCategoryLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectCategoryLabel.horizontalIndent = 5;
        selectCategoryLabel.setLayoutData((Object)gd_selectCategoryLabel);
        selectCategoryLabel.setSize(74, 15);
        selectCategoryLabel.setText("Select Category:");
        this.selectCategoryComboViewer = new ComboViewer(this.categoriesComposite, 8);
        this.selectCategoryComboViewer.setContentProvider((IContentProvider)new SelectCategoryComboViewerContentProvider());
        this.selectCategoryComboViewer.setLabelProvider((IBaseLabelProvider)new SelectCategoryComboViewerLabelProvider());
        this.selectCategoryCombo = this.selectCategoryComboViewer.getCombo();
        this.selectCategoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.selectCategoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)CategoryBrowserView.this.selectCategoryComboViewer.getSelection();
                Object selectedObject = sel.getFirstElement();
                if (selectedObject instanceof String) {
                    String category = (String)selectedObject;
                    CategoryBrowserView.this.getController().setSelectedCategory(category);
                }
            }
        });
        this.categoriesComposite.layout(true);
        this.resultCatComposite = new Composite(container, 2048);
        this.resultCatComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.resultCatComposite.setLayout((Layout)new GridLayout(1, false));
        this.srtitlecomposite = new Composite(this.resultCatComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.srtitlecomposite.setLayout((Layout)gridLayout);
        this.srtitlecomposite.setLayoutData((Object)gridData);
        Label categoryMatchResultsLabel = new Label(this.srtitlecomposite, 0);
        Font initialFont = categoryMatchResultsLabel.getFont();
        Device device = initialFont.getDevice();
        FontData[] fontData = initialFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(1);
            ++i;
        }
        Font newFont = new Font(device, fontData);
        categoryMatchResultsLabel.setFont(newFont);
        categoryMatchResultsLabel.setText("Category matching results: ");
        this.resultsLabel = new Label(this.srtitlecomposite, 0);
        this.resultsLabel.setText("");
        Composite resultTreeComposite = new Composite(this.resultCatComposite, 0);
        GridData gd_resultTreeComposite = new GridData(4, 4, true, true, 1, 1);
        gd_resultTreeComposite.horizontalIndent = 3;
        resultTreeComposite.setLayoutData((Object)gd_resultTreeComposite);
        resultTreeComposite.setLayout((Layout)new FillLayout(256));
        this.resultTreeViewer = new TreeViewer(resultTreeComposite, 4);
        this.resultTreeViewer.setLabelProvider((IBaseLabelProvider)new DocumentTreeLabelProvider());
        this.resultTreeViewer.setContentProvider((IContentProvider)new DocumentTreeContentProvider());
        this.resultTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    DocForTreeViewer doc = (DocForTreeViewer)selection.getFirstElement();
                    if (doc.isDocument()) {
                        CategoryBrowserView.this.controller.openDocument(new ResourceId(doc.getResourceId()), CategoryBrowserView.this.getSite());
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to open document view", t);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.resultTreeViewer);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.controller.onViewCreation();
    }

    public void refresh() {
    }

    public void removeListeners() {
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
    }

    private void createActions() {
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
    }

    public void setFocus() {
    }

    void setActiveConfigProject() {
        final Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Color red = dsp.getSystemColor(3);
                    Color black = dsp.getSystemColor(2);
                    Font font = new Font((Device)dsp, "Tahoma", 9, 1);
                    CategoryBrowserView.this.getActiveConfigProjectLabel().setFont(font);
                    if (CategoryBrowserView.this.getController().getModel().getActiveConfigProject() == null) {
                        CategoryBrowserView.this.getActiveConfigProjectLabel().setForeground(red);
                        CategoryBrowserView.this.getActiveConfigProjectLabel().setText("Not found");
                    } else {
                        CategoryBrowserView.this.getActiveConfigProjectLabel().setForeground(black);
                        CategoryBrowserView.this.getActiveConfigProjectLabel().setText(CategoryBrowserView.this.getController().getModel().getActiveConfigProject().getName());
                    }
                    CategoryBrowserView.this.getCategoriesComposite().layout();
                }
                catch (Throwable t) {
                    log.error("Failed to get colors from the system", t);
                }
            }
        });
    }

    void disableComboCategories() {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CategoryBrowserView.this.getCategoryComboViewer().getCombo().setEnabled(false);
                }
                catch (Throwable t) {
                    log.error("Failed to disable combo viewer", t);
                }
            }
        });
    }

    void enableComboCategories() {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CategoryBrowserView.this.getCategoryComboViewer().getCombo().setEnabled(true);
                }
                catch (Throwable t) {
                    log.error("Failed to disable combo viewer", t);
                }
            }
        });
    }

    void setSelectCategory() {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CategoryBrowserView.this.getController() != null && CategoryBrowserView.this.getController().getModel() != null) {
                        StructuredSelection sel = new StructuredSelection((Object)CategoryBrowserView.this.getController().getModel().getSelectedCategory());
                        CategoryBrowserView.this.getCategoryComboViewer().setSelection((ISelection)sel);
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to set the selected category", t);
                }
            }
        });
    }

    void setComboCategories(final List<String> categories) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CategoryBrowserView.this.getCategoryComboViewer().setInput(new ArrayList());
                    CategoryBrowserView.this.getCategoryComboViewer().setInput((Object)categories);
                    CategoryBrowserView.this.getCategoryComboViewer().refresh();
                    CategoryBrowserView.this.getCategoriesComposite().layout();
                }
                catch (Throwable t) {
                    log.error("Failed to show message to TreeViewer", t);
                }
            }
        });
    }

    void showOneLineProgressMessage(final String msg) {
        if (this.resultTreeViewer == null) {
            return;
        }
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DocForTreeViewer[] temp = new DocForTreeViewer[]{new DocForTreeViewer(msg, "", "message")};
                    CategoryBrowserView.this.getResultTreeViewer().setInput((Object)temp);
                    CategoryBrowserView.this.getResultTreeViewer().refresh();
                }
                catch (Throwable t) {
                    log.error("Failed to show message to TreeViewer", t);
                }
            }
        });
    }

    void showSeveralLinesProgressMessage(final String msg) {
        if (this.resultTreeViewer == null) {
            return;
        }
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] lines = msg.split("\n");
                    DocForTreeViewer[] temp = new DocForTreeViewer[lines.length];
                    int i = 0;
                    while (i < lines.length) {
                        temp[i] = new DocForTreeViewer(lines[i], "", "message");
                        ++i;
                    }
                    CategoryBrowserView.this.getResultTreeViewer().setInput((Object)temp);
                    CategoryBrowserView.this.getResultTreeViewer().refresh();
                }
                catch (Throwable t) {
                    log.error("Failed to show message to TreeViewer", t);
                }
            }
        });
    }

    public Label getResultLabel() {
        return this.resultsLabel;
    }

    public TreeViewer getResultTreeViewer() {
        return this.resultTreeViewer;
    }

    public ComboViewer getCategoryComboViewer() {
        return this.selectCategoryComboViewer;
    }

    public Label getActiveConfigProjectLabel() {
        return this.activeConfigProjectLabel;
    }

    public CategoryBrowserController getController() {
        return this.controller;
    }

    public Composite getCategoriesComposite() {
        return this.categoriesComposite;
    }

    public void showCategoryMatcherResults(final DocForTreeViewer[] dataset) {
        if (dataset.length == 0 && this.getSelectedCategory() != null && this.getSelectedCategory().length() > 0) {
            this.showOneLineProgressMessage("No documents found for such category");
        } else if (this.getSelectedCategory() == null || this.getSelectedCategory().length() == 0) {
            this.showOneLineProgressMessage("Please select a category");
        } else {
            Display dsp = this.getSite().getShell().getDisplay();
            dsp.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CategoryBrowserView.this.getResultTreeViewer().setInput((Object)dataset);
                        CategoryBrowserView.this.getResultTreeViewer().refresh();
                    }
                    catch (Throwable t) {
                        log.error("Failed to show the search results");
                    }
                }
            });
        }
    }

    private String getSelectedCategory() {
        return this.getController().getModel().getSelectedCategory();
    }

    private class DocumentTreeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private DocumentTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            DocForTreeViewer docu = (DocForTreeViewer)parentElement;
            return docu.children;
        }

        public Object getParent(Object element) {
            DocForTreeViewer document = (DocForTreeViewer)element;
            return document.parent;
        }

        public boolean hasChildren(Object element) {
            DocForTreeViewer docu = (DocForTreeViewer)element;
            return docu.children.length > 0;
        }
    }

    private class DocumentTreeLabelProvider
    extends LabelProvider {
        private DocumentTreeLabelProvider() {
        }

        public String getText(Object element) {
            DocForTreeViewer docu = (DocForTreeViewer)element;
            return docu.getLabel();
        }

        public Image getImage(Object element) {
            DocForTreeViewer docu = (DocForTreeViewer)element;
            if (docu.getDocType().equals("message")) {
                return null;
            }
            if (docu.children.length == 0) {
                if (docu.getDocType().equals("html")) {
                    return CmatcherUIPlugin.getPlugin().getImageRegistry().get("html_document");
                }
                if (docu.getDocType().equals("txt")) {
                    return CmatcherUIPlugin.getPlugin().getImageRegistry().get("txt_document");
                }
                if (docu.getDocType().equals("pdf")) {
                    return CmatcherUIPlugin.getPlugin().getImageRegistry().get("pdf_document");
                }
                if (docu.getDocType().equals("doc")) {
                    return CmatcherUIPlugin.getPlugin().getImageRegistry().get("word_document");
                }
                if (docu.getDocType().equals("ptx")) {
                    return CmatcherUIPlugin.getPlugin().getImageRegistry().get("powerpoint_document");
                }
                if (docu.getDocType().equals("xls")) {
                    return CmatcherUIPlugin.getPlugin().getImageRegistry().get("excel_document");
                }
                return CmatcherUIPlugin.getPlugin().getImageRegistry().get("html_document");
            }
            return CmatcherUIPlugin.getPlugin().getImageRegistry().get("folder");
        }
    }

    private class PartListenerImpl
    extends PartListenerAdapter {
        private PartListenerImpl() {
        }

        public void partClosed(IWorkbenchPart part) {
            super.partClosed(part);
            if (CategoryBrowserView.this == part) {
                CategoryBrowserView.this.controller.onPartClosed();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            super.partDeactivated(part);
            if (CategoryBrowserView.this == part) {
                CategoryBrowserView.this.controller.onPartDeactivated();
            }
        }

        public void partActivated(IWorkbenchPart part) {
            super.partActivated(part);
            if (CategoryBrowserView.this == part) {
                CategoryBrowserView.this.controller.onPartActivated();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            super.partBroughtToTop(part);
            if (CategoryBrowserView.this == part) {
                CategoryBrowserView.this.controller.onPartBroughtToTop();
            }
        }

        public void partOpened(IWorkbenchPart part) {
            super.partOpened(part);
            if (CategoryBrowserView.this == part) {
                CategoryBrowserView.this.controller.onPartOpened();
            }
        }
    }

    private class SelectCategoryComboViewerContentProvider
    extends StructuredContentProviderAdapter {
        private SelectCategoryComboViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof String) {
                return new String[]{(String)inputElement};
            }
            if (inputElement instanceof List) {
                List categories = (List)inputElement;
                return categories.toArray(new String[0]);
            }
            return null;
        }
    }

    private class SelectCategoryComboViewerLabelProvider
    extends LabelProviderAdapter {
        private SelectCategoryComboViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return "";
        }
    }
}

