/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.text;

import it.jrc.osint.extract.ExtractPlugin;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.text.TextExtractionPreferences;
import it.jrc.osint.extract.text.TextExtractionProvider;
import it.jrc.osint.extract.text.TextExtractionService;
import it.jrc.osint.extract.text.internal.TextExtractionServiceImpl;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TextExtractPlugin
implements BundleActivator {
    private static final Logger log = LogManager.getLogger((String)TextExtractPlugin.class.getCanonicalName());
    public static final String PLUGIN_ID = "it.jrc.osint.extract.text";
    private static final String TEXT_EXTRACTION_PROVIDER_EXTENSION_ID = "textExtractionProvider";
    private static BundleContext context;
    private static TextExtractPlugin plugin;
    private TextExtractionServiceImpl textExtractionService;
    private boolean extensionsLoaded;
    private EventBroker eventBroker;

    static BundleContext getContext() {
        return context;
    }

    public static EventBroker getEventBroker() {
        return TextExtractPlugin.getPlugin().eventBroker;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        this.eventBroker = new EventBroker(context);
        this.initPreferences();
        this.textExtractionService = new TextExtractionServiceImpl(this.eventBroker, TextExtractPlugin.getWorkspaceService());
        this.textExtractionService.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.eventBroker.stop();
        context = null;
        plugin = null;
    }

    public TextExtractionPreferences getPreferences() {
        return new TextExtractionPreferences(PLUGIN_ID);
    }

    public static TextExtractPlugin getPlugin() {
        return plugin;
    }

    public static TextExtractionService getTextExtractionService() {
        return TextExtractPlugin.getPlugin().obtainService();
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    public static ExtractionService getEntityExtractionService() {
        return ExtractPlugin.getExtractionService();
    }

    private TextExtractionService obtainService() {
        this.loadTextExtractorExtensions();
        return this.textExtractionService;
    }

    private void loadTextExtractorExtensions() {
        if (this.extensionsLoaded) {
            return;
        }
        this.extensionsLoaded = true;
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("it.jrc.osint.extract.text.textExtractionProvider");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                String contentType = e.getAttribute("contentType");
                String fileExtensions = e.getAttribute("fileExtensions");
                String[] fExtensions = null;
                if (fileExtensions != null) {
                    fExtensions = fileExtensions.split(",");
                }
                if (o instanceof TextExtractionProvider && (contentType != null || fExtensions != null)) {
                    this.textExtractionService.register(contentType, fExtensions, (TextExtractionProvider)o);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.error("Failed to load text extractor extensions", (Throwable)e);
        }
    }

    private void initPreferences() {
        TextExtractionPreferences tePrefs = new TextExtractionPreferences(PLUGIN_ID);
        tePrefs.init();
    }
}

