/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.text.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.extract.text.ErrorConditions;
import it.jrc.osint.extract.text.TextExtractionProvider;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;

public class OSINTDocumentTextExtractionProvider
implements TextExtractionProvider {
    private static Logger log = LogManager.getLogger((String)OSINTDocumentTextExtractionProvider.class.getCanonicalName());

    @Override
    public OperationStatus extract(InputStream in, DocumentMetaItem anItem) {
        OperationStatus resultStatus;
        block6: {
            RSSItem item = anItem.getItem();
            RepositoryMetaData rmd = new RepositoryMetaData(new DocumentMetaItem(item));
            ErrorStatusMetaData emd = new ErrorStatusMetaData(new DocumentMetaItem(item));
            resultStatus = OperationStatus.OK_STATUS;
            try {
                try {
                    RSSParser rssParser = new RSSParser();
                    RSS rss = rssParser.parse((Reader)new InputStreamReader(in, "UTF-8"));
                    Vector items = rss.getItems();
                    if (items.size() > 0) {
                        RSSItem loadedItem = (RSSItem)items.get(0);
                        item.setTitle(loadedItem.getTitle());
                        item.setGuid(loadedItem.getGuid());
                        item.setLink(loadedItem.getLink());
                        item.setText(loadedItem.getText());
                        item.setLanguage(loadedItem.getLanguage());
                        item.setContentType(loadedItem.getContentType());
                        item.setPubDate(loadedItem.getPubDate());
                        item.setLastModified(loadedItem.getLastModified());
                        rmd.setTextExtracted(true);
                        break block6;
                    }
                    resultStatus = new OperationStatus(ErrorConditions.getErrorConditions().getErrorCondition(ErrorConditions.RSS_ITEM_NOT_FOUND));
                    emd.setOperationStatus(resultStatus);
                    rmd.setTextExtracted(false);
                }
                catch (Throwable t) {
                    log.error("Failed to extract text from RSSItem", t);
                    resultStatus = new OperationStatus(ErrorConditions.getErrorConditions().getErrorCondition(ErrorConditions.TEXT_EXTRACTION_FAILED, t));
                    emd.setOperationStatus(resultStatus);
                    rmd.setTextExtracted(false);
                    FileUtil.close((InputStream)in);
                }
            }
            finally {
                FileUtil.close((InputStream)in);
            }
        }
        return resultStatus;
    }
}

