/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.text.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.extract.text.ErrorConditions;
import it.jrc.osint.extract.text.TextExtractionProvider;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.util.io.FileReaderUtil;
import it.jrc.osint.util.io.FileUtil;
import java.io.InputStream;

public class TextTextExtractionProvider
implements TextExtractionProvider {
    private static final Logger log = LogManager.getLogger((String)TextTextExtractionProvider.class.getCanonicalName());

    @Override
    public OperationStatus extract(InputStream in, DocumentMetaItem anItem) {
        OperationStatus resultStatus = OperationStatus.OK_STATUS;
        ErrorStatusMetaData emd = new ErrorStatusMetaData(anItem);
        RepositoryMetaData rmd = new RepositoryMetaData(anItem);
        try {
            try {
                FileReaderUtil readerUtil = new FileReaderUtil();
                String text = readerUtil.read(in, "UTF-8");
                anItem.setText(text);
                rmd.setTextExtracted(true);
            }
            catch (Throwable t) {
                resultStatus = new OperationStatus(ErrorConditions.getErrorConditions().getErrorCondition(ErrorConditions.TEXT_EXTRACTION_FAILED, t));
                emd.setOperationStatus(resultStatus);
                rmd.setTextExtracted(false);
                log.error("Failed to extract text", t);
                FileUtil.close((InputStream)in);
            }
        }
        finally {
            FileUtil.close((InputStream)in);
        }
        return resultStatus;
    }
}

