/*
 * Decompiled with CFR 0.152.
 */
package test.extract.text;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.extract.text.TextExtractionService;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.util.test.TestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

public class _TestTextExtraction {
    private static final Logger log = Logger.getLogger((String)_TestTextExtraction.class.getCanonicalName());
    private static TextExtractionService tes;
    private static String testBaseDir;

    @BeforeClass
    public static void setup() {
        TestUtil.setupLogging();
        testBaseDir = String.valueOf(System.getProperty("user.dir")) + File.separator + "test";
        System.out.println("testBaseDir=" + testBaseDir);
    }

    @Test
    public void detectContentTypes() {
        File[] testFiles;
        File testBaseDirFile = new File(testBaseDir);
        File[] fileArray = testFiles = testBaseDirFile.listFiles();
        int n = testFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File testFile = fileArray[n2];
            FileInputStream in = null;
            try {
                in = new FileInputStream(testFile);
                String contentType = tes.detectContentType(in, testFile.getName());
                log.debug((Object)("File: " + testFile.getName() + "; contentType: " + contentType));
            }
            catch (Throwable t) {
                log.error((Object)"Failed to detect content type", t);
            }
            ++n2;
        }
    }

    public void extractFromOSINTDocument() {
    }

    public void extractFromHTML() {
    }

    public void extractFromText() {
    }

    @Test
    public void extractWord97() {
        Assert.assertEquals((boolean)true, (boolean)this.extractFiles(this.getTestFiles("doc"), "Lorem ipsum"));
    }

    @Test
    public void extractExcel97() {
        Assert.assertEquals((boolean)true, (boolean)this.extractFiles(this.getTestFiles("xls"), "Sheet1"));
    }

    @Test
    public void extractPowerpoint97() {
        Assert.assertEquals((boolean)true, (boolean)this.extractFiles(this.getTestFiles("ppt"), "Lorem ipsum"));
    }

    @Test
    public void extractWord2010() {
        Assert.assertEquals((boolean)true, (boolean)this.extractFiles(this.getTestFiles("docx"), "Lorem ipsum"));
    }

    @Test
    public void extractExcel2010() {
        Assert.assertEquals((boolean)true, (boolean)this.extractFiles(this.getTestFiles("xlsx"), "Sheet1"));
    }

    @Test
    public void extractPowerpoint2010() {
        Assert.assertEquals((boolean)true, (boolean)this.extractFiles(this.getTestFiles("pptx"), "Lorem ipsum"));
    }

    private boolean extractFiles(File[] inputFiles, String matchResultText) {
        boolean result = true;
        File[] fileArray = inputFiles;
        int n = inputFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File inFile = fileArray[n2];
            try {
                FileInputStream in = new FileInputStream(inFile);
                DocumentMetaItem metaItem = new DocumentMetaItem();
                RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
                rmd.setFileName(inFile.getName());
                metaItem.setContentType("application/msword");
                tes.extract(in, inFile.getName(), metaItem);
                if (!metaItem.getText().startsWith(matchResultText)) {
                    result = false;
                }
                Assert.assertEquals((boolean)true, (boolean)rmd.isTextExtracted());
            }
            catch (Throwable t) {
                log.error((Object)("Failed to extract text from " + inFile.getName()));
            }
            ++n2;
        }
        return result;
    }

    private File[] getTestFiles(final String fileExtension) {
        File testBaseDirFile = new File(testBaseDir);
        return testBaseDirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(fileExtension);
            }
        });
    }
}

