/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.dialogs;

import it.jrc.osint.analysis.ui.dialogs.SelectEntityTypesController;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class SelectEntityTypesDialog
extends Dialog {
    private SelectEntityTypesController controller;
    private Table typesTable;
    private TableViewer typesTableViewer;

    SelectEntityTypesDialog(Shell parentShell) {
        super(parentShell);
    }

    SelectEntityTypesDialog(Shell parentShell, SelectEntityTypesController controller) {
        this(parentShell);
        this.controller = controller;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Visible Entity Types");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblSelectVisibleEntity = new Label(container, 0);
        lblSelectVisibleEntity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSelectVisibleEntity.setText("Filter visible entity types:");
        Composite typesTableContainer = new Composite(container, 0);
        typesTableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout columnLayout = new TableColumnLayout();
        typesTableContainer.setLayout((Layout)columnLayout);
        this.typesTable = new Table(typesTableContainer, 67584);
        this.typesTable.setHeaderVisible(true);
        this.typesTable.setLinesVisible(true);
        this.typesTableViewer = new TableViewer(this.typesTable);
        this.typesTableViewer.setContentProvider((IContentProvider)new EntityTypesListContentProvider());
        this.typesTableViewer.setLabelProvider((IBaseLabelProvider)new EntityTypeLabelProvider());
        TableColumn nameColumn = new TableColumn(this.typesTable, 0);
        nameColumn.setText("Entity Type");
        TableViewerColumn nameColumnViewer = new TableViewerColumn(this.typesTableViewer, nameColumn);
        nameColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return "";
                }
                if (element instanceof EntityType) {
                    return ((EntityType)element).getName();
                }
                return "";
            }
        });
        ColumnWeightData nameColumnWeightData = new ColumnWeightData(80);
        nameColumnWeightData.minimumWidth = 150;
        columnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)nameColumnWeightData);
        TableColumn visibleColumn = new TableColumn(this.typesTable, 0);
        visibleColumn.setText("Visible");
        TableViewerColumn visibleColumnViewer = new TableViewerColumn(this.typesTableViewer, visibleColumn);
        visibleColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof EntityType) {
                    return SelectEntityTypesDialog.this.typeVisibleLabel((EntityType)element);
                }
                return "";
            }
        });
        ColumnWeightData visibleColumnWeigthData = new ColumnWeightData(20);
        visibleColumnWeigthData.minimumWidth = 100;
        columnLayout.setColumnData((Widget)visibleColumn, (ColumnLayoutData)visibleColumnWeigthData);
        visibleColumnViewer.setEditingSupport((EditingSupport)new VisibleColumnEditingSupport(this.typesTableViewer));
        this.controller.onViewCreation();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(495, 388);
    }

    private String typeVisibleLabel(EntityType aType) {
        if (this.controller.isTypeVisible(aType)) {
            return "visible";
        }
        return "not visible";
    }

    void setEntityTypesTableInput(List<EntityType> availableTypes) {
        this.typesTableViewer.setInput(availableTypes);
    }

    void refreshEntityTypesTable() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectEntityTypesDialog.this.typesTableViewer.refresh();
            }
        });
    }

    private class EntityTypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EntityTypeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return element.toString();
                }
                case 1: {
                    if (!(element instanceof EntityType)) break;
                    return SelectEntityTypesDialog.this.typeVisibleLabel((EntityType)element);
                }
            }
            return "unknown idx " + columnIndex;
        }
    }

    private class EntityTypesListContentProvider
    extends StructuredContentProviderAdapter {
        private EntityTypesListContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof String) {
                return new String[]{(String)input};
            }
            if (input instanceof List) {
                List typesList = (List)input;
                Collections.sort(typesList);
                return typesList.toArray();
            }
            return new Object[0];
        }
    }

    private class VisibleColumnEditingSupport
    extends EditingSupport {
        public VisibleColumnEditingSupport(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor(null, 32);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return SelectEntityTypesDialog.this.controller.isTypeVisible((EntityType)element);
        }

        protected void setValue(Object element, Object value) {
            SelectEntityTypesDialog.this.controller.changeVisibleStateOfType((EntityType)element, (Boolean)value);
        }
    }
}

