/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.analysis.ui.editors.DocumentViewerEditorModel;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.LoggingRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class DocumentOnlineViewer
extends Composite {
    private static final Logger log = LogManager.getLogger((String)DocumentOnlineViewer.class.getName());
    private Browser browser;
    private String currentURL;
    private DocumentViewerEditorModel model;

    public DocumentOnlineViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, 0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isVisible()) {
            this.loadCurrentUrl();
        }
    }

    public void setModel(DocumentViewerEditorModel model) {
        this.model = model;
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || evt.getPropertyName() == null) {
                    return;
                }
                if ("changed".equals(evt.getPropertyName())) {
                    String sourceURL = DocumentOnlineViewer.this.model.getSourceURL();
                    DocumentOnlineViewer.this.setUrl(sourceURL);
                }
            }
        });
        this.setUrl(this.model.getSourceURL());
    }

    public void setUrl(String newUrl) {
        if (newUrl == null) {
            return;
        }
        this.currentURL = newUrl;
        Display.getDefault().asyncExec((Runnable)new LoggingRunnable(log){

            protected void runWithLogging() {
                if (DocumentOnlineViewer.this.isVisible()) {
                    DocumentOnlineViewer.this.loadCurrentUrl();
                }
            }
        });
    }

    private void loadCurrentUrl() {
        if (this.currentURL != null) {
            this.browser.setUrl(this.currentURL);
        }
    }

    public void dispose() {
        if (!this.browser.isDisposed()) {
            this.browser.dispose();
        }
        super.dispose();
    }

    public boolean setFocus() {
        this.loadCurrentUrl();
        return true;
    }
}

