/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.resources.IFile;

public class DocumentViewerEditorModel {
    public static final String PROP_CHANGED = "changed";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResourceId resourceId;
    private String sourceURL;

    public DocumentViewerEditorModel(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public DocumentViewerEditorModel(ResourceId docId) {
        this.resourceId = docId;
    }

    public ResourceId getResourceId() {
        return this.resourceId;
    }

    public DocumentMetaItem loadDocumentMetaItem(ResourceId docId) {
        if (docId == null || ResourceId.NULL_ID.equals((Object)docId)) {
            return null;
        }
        WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByDocumentId(this.resourceId);
        return cp.getMetaItem(this.resourceId);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangedListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setResourceId(ResourceId resourceId) {
        this.resourceId = resourceId;
        this.propertyChangeSupport.firePropertyChange(PROP_CHANGED, false, true);
    }

    public String getSourceURL() {
        if (this.hasDocument()) {
            DocumentMetaItem metaItem = this.loadDocumentMetaItem(this.resourceId);
            if (metaItem == null) {
                return this.sourceURL;
            }
            if (metaItem.getLink() == null || "".equals(metaItem.getLink())) {
                WorkspaceService wks = WorkspacePlugin.getWorkspaceService();
                CaseProject cp = wks.getCaseProjectByDocumentId(metaItem.getResourceId());
                IFile file = cp.getFile(this.resourceId);
                return file.getLocationURI().toString();
            }
            return metaItem.getLink();
        }
        return this.sourceURL;
    }

    public boolean hasDocument() {
        return this.resourceId != null;
    }

    public boolean hasHTMLSource() {
        if (this.hasDocument()) {
            DocumentMetaItem metaItem = this.loadDocumentMetaItem(this.resourceId);
            if (metaItem == null) {
                return false;
            }
            RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
            return "it.jrc.osint.contenttype.HTML".equals(rmd.getContentTypeId());
        }
        return false;
    }
}

