/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.graph;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.graph.EntityEntityEdge;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.graph.GraphViewController;
import it.jrc.osint.analysis.ui.graph.GraphViewModel;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class GraphView
extends ViewPart
implements IZoomableWorkbenchPart {
    public static final Logger log = LogManager.getLogger((String)GraphView.class.getName());
    private static final int HORIZONTAL_TREE = 0;
    private static final int VERTICAL_TREE = 1;
    private static final int RADIAL = 2;
    private static final int GRID = 3;
    private static final int SPRING = 4;
    private GraphViewController controller;
    private GraphViewer viewer;
    private Action resetAction;
    private Action refreshAction;
    private Action setVisibleEntityTypesAction;
    private Action clearGraphAction;
    private Object pinnedNode = null;
    public static final String ID = "it.jrc.osint.analysis.ui.views.GraphView";
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            if (sourcepart == GraphView.this) {
                return;
            }
        }
    };
    private IDoubleClickListener dblClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            Object selectedObj;
            IStructuredSelection structuredSel = (IStructuredSelection)event.getSelection();
            if (!structuredSel.isEmpty() && (selectedObj = structuredSel.toArray()[0]) instanceof EntityConnectionData) {
                EntityConnectionData ecd = (EntityConnectionData)selectedObj;
                Entity sourceVertex = (Entity)ecd.source;
                Entity destVertex = (Entity)ecd.dest;
                GraphView.this.controller.showConnectionDialog(GraphView.this.getSite().getShell(), sourceVertex, destVertex);
            }
        }
    };

    public GraphView() {
        this.controller = new GraphViewController(this);
    }

    public void refresh(final GraphViewModel viewModel) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GraphView.this.viewer.setInput((Object)viewModel.getRelationshipGraph().getVertices());
                GraphView.this.viewer.refresh();
            }
        });
    }

    private IAction makeShowConnectionAction(final Entity sourceVertex, final Entity destVertex) {
        Action showEdgeDocumentsAction = new Action(){

            public void run() {
                GraphView.this.controller.showConnectionDialog(GraphView.this.getSite().getShell(), sourceVertex, destVertex);
            }
        };
        showEdgeDocumentsAction.setText("Show connecting documents...");
        return showEdgeDocumentsAction;
    }

    private IAction makeRemoveAction(final Entity entityToRemove) {
        Action removeAction = new Action(){

            public void run() {
                GraphView.this.controller.remove(entityToRemove);
                GraphView.this.viewer.refresh();
            }
        };
        removeAction.setText("Remove '" + entityToRemove.toString() + "'");
        return removeAction;
    }

    private IAction makeShowRelatedEntitiesAction(final Entity entityVertex) {
        Action showRelatedEntitiesAction = new Action(){

            public void run() {
                GraphView.this.controller.showRelatedEntities(entityVertex);
            }
        };
        showRelatedEntitiesAction.setText("Show related entities in Entity Browser");
        return showRelatedEntitiesAction;
    }

    private void contributeZoomActions(IMenuManager manager) {
        MenuManager zoomSubmenu = new MenuManager("Zoom");
        ZoomContributionViewItem toolbarZoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this);
        zoomSubmenu.add((IContributionItem)toolbarZoomContributionViewItem);
        manager.add((IContributionItem)zoomSubmenu);
    }

    private void contributeLayoutActions(IMenuManager manager) {
        MenuManager layoutSubmenu = new MenuManager("Set Layout");
        layoutSubmenu.add((IAction)new Action("Horizontal Tree", 2){

            public void run() {
                GraphView.this.viewer.setLayoutAlgorithm(GraphView.this.setLayout(0), true);
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        });
        layoutSubmenu.add((IAction)new Action("Vertical Tree", 2){

            public void run() {
                GraphView.this.viewer.setLayoutAlgorithm(GraphView.this.setLayout(1), true);
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        });
        layoutSubmenu.add((IAction)new Action("Radial Graph", 2){

            public void run() {
                GraphView.this.viewer.setLayoutAlgorithm(GraphView.this.setLayout(2), true);
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        });
        layoutSubmenu.add((IAction)new Action("Grid Layout", 2){

            public void run() {
                GraphView.this.viewer.setLayoutAlgorithm(GraphView.this.setLayout(3), true);
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        });
        layoutSubmenu.add((IAction)new Action("Spring Layout", 2){

            public void run() {
                GraphView.this.viewer.setLayoutAlgorithm(GraphView.this.setLayout(4), true);
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        });
        layoutSubmenu.add((IAction)new Action("Default Layout", 2){

            public void run() {
                GraphView.this.viewer.setLayoutAlgorithm(GraphView.this.setLayout(Integer.MAX_VALUE), true);
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        });
        manager.add((IContributionItem)layoutSubmenu);
    }

    private void makeDefaultActions() {
        this.resetAction = new Action("Reset Layout and Visible Types"){

            public void run() {
                GraphView.this.controller.setFocusedVertex(null);
                GraphView.this.controller.resetVisibleEntityTypes();
                GraphView.this.viewer.applyLayout();
                GraphView.this.viewer.refresh();
            }
        };
        this.refreshAction = new Action("Refresh"){

            public void run() {
                GraphView.this.controller.refresh();
            }
        };
        this.setVisibleEntityTypesAction = new Action("Filter Entity Types..."){

            public void run() {
                GraphView.this.controller.showSelectEntityTypesDialog(GraphView.this.getSite().getShell());
            }
        };
        this.clearGraphAction = new Action("Clear Graph"){

            public void run() {
                GraphView.this.controller.clearGraph();
            }
        };
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        this.fillContextMenu((IMenuManager)menuMgr);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GraphView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        this.contributeLayoutActions(manager);
        manager.add((IAction)this.setVisibleEntityTypesAction);
        manager.add((IAction)this.resetAction);
        manager.add((IContributionItem)new Separator());
        this.contributeZoomActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearGraphAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        if (((IStructuredSelection)this.viewer.getSelection()).size() > 0) {
            Object selectedObject = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (selectedObject instanceof Entity) {
                manager.add(this.makeRemoveAction((Entity)selectedObject));
                manager.add(this.makeShowRelatedEntitiesAction((Entity)selectedObject));
            }
            if (selectedObject instanceof EntityConnectionData) {
                EntityConnectionData ecd = (EntityConnectionData)selectedObject;
                Entity sourceVertex = (Entity)ecd.source;
                Entity destVertex = (Entity)ecd.dest;
                manager.add(this.makeShowConnectionAction(sourceVertex, destVertex));
            }
        }
        if (((IStructuredSelection)this.viewer.getSelection()).size() > 0 || this.pinnedNode != null) {
            manager.add((IContributionItem)new Separator());
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.viewer = new GraphViewer(parent, 2048);
        this.viewer.setContentProvider((IContentProvider)new GraphEntityContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
        this.viewer.setLayoutAlgorithm(this.setLayout(Integer.MAX_VALUE), true);
        this.viewer.setFilters(new ViewerFilter[]{new EntityTypeFilter()});
        this.viewer.applyLayout();
        this.viewer.addDoubleClickListener(this.dblClickListener);
        this.makeDefaultActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void addEntity(Entity anEntity, ResourceId projectId) {
        this.controller.addEntity(anEntity, projectId);
    }

    private LayoutAlgorithm setLayout(int style) {
        switch (style) {
            case 1: {
                return new HorizontalTreeLayoutAlgorithm(1);
            }
            case 0: {
                return new TreeLayoutAlgorithm(1);
            }
            case 2: {
                return new RadialLayoutAlgorithm(1);
            }
            case 3: {
                return new GridLayoutAlgorithm(1);
            }
            case 4: {
                return new SpringLayoutAlgorithm(1);
            }
        }
        return new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{new RadialLayoutAlgorithm(1), new SpringLayoutAlgorithm(1)});
    }

    public void setFocus() {
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    public void dispose() {
        this.controller.onDispose();
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    public void setFocusedVertex(Entity gv) {
        this.controller.setFocusedVertex(gv);
        this.viewer.applyLayout();
        this.viewer.refresh();
    }

    private GraphViewModel getModel() {
        return this.controller.getContentModel();
    }

    boolean showConfirmationDialog(String title, String message) {
        return MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)title, (String)message);
    }

    private class EntityTypeFilter
    extends ViewerFilter {
        private EntityTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Entity) {
                Entity entity = (Entity)element;
                String type = entity.getType();
                return GraphView.this.controller.isTypeVisible(type);
            }
            return true;
        }
    }

    private class GraphEntityContentProvider
    implements IGraphEntityContentProvider {
        private GraphEntityContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (GraphView.this.getModel().getRelationshipGraph() == null) {
                return new Object[0];
            }
            if (inputElement instanceof Set) {
                Set vertices = (Set)inputElement;
                return vertices.toArray();
            }
            return new Object[0];
        }

        public Object[] getConnectedTo(Object vertex) {
            if (GraphView.this.getModel().getRelationshipGraph() == null) {
                return new Object[0];
            }
            if (vertex instanceof Entity) {
                Entity entityVertex = (Entity)vertex;
                Set lev = GraphView.this.getModel().getRelationshipGraph().getRelatedVertices((Object)entityVertex);
                Iterator gvIterator = lev.iterator();
                while (gvIterator.hasNext()) {
                    Entity v = (Entity)gvIterator.next();
                    if (v.hashCode() >= vertex.hashCode()) continue;
                    gvIterator.remove();
                }
                return lev.toArray();
            }
            return null;
        }
    }

    private class GraphLabelProvider
    extends LabelProvider
    implements IConnectionStyleProvider {
        private GraphLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return AnalysisUIPlugin.getPlugin().getImageRegistry().get("document");
            }
            if (element instanceof Entity) {
                Entity entity = (Entity)element;
                String type = entity.getType();
                return AnalysisUIPlugin.getPlugin().getImageForEntityTypeId(type);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String myNode = (String)element;
                return "docId:" + myNode;
            }
            if (element instanceof Entity) {
                Entity entity = (Entity)element;
                return entity.getName();
            }
            if (element instanceof EntityEntityEdge) {
                EntityEntityEdge myConnection = (EntityEntityEdge)element;
                return myConnection.toString();
            }
            if (element instanceof EntityConnectionData) {
                return "";
            }
            throw new RuntimeException("Wrong type: " + element.getClass().toString());
        }

        public int getConnectionStyle(Object rel) {
            return 4;
        }

        public Color getColor(Object rel) {
            if (rel instanceof EntityEntityEdge && ((EntityEntityEdge)rel).getWeight() > 2) {
                return AnalysisUIPlugin.getPlugin().getColor("red");
            }
            return AnalysisUIPlugin.getPlugin().getColor("black");
        }

        public Color getHighlightColor(Object rel) {
            return null;
        }

        public int getLineWidth(Object rel) {
            if (rel instanceof EntityEntityEdge) {
                return ((EntityEntityEdge)rel).getWeight();
            }
            if (rel instanceof EntityConnectionData) {
                EntityConnectionData ecd = (EntityConnectionData)rel;
                Entity sourceVertex = (Entity)ecd.source;
                Entity destVertex = (Entity)ecd.dest;
                int edgeWeight = GraphView.this.controller.getEdgeWeight(sourceVertex, destVertex);
                return this.calculateLineWidth(edgeWeight);
            }
            return -1;
        }

        private int calculateLineWidth(int edgeWeight) {
            int minWidth = 1;
            int maxWidth = 8;
            int width = edgeWeight / 3;
            if (width < minWidth) {
                return minWidth;
            }
            if (width > maxWidth) {
                return maxWidth;
            }
            return width;
        }

        public IFigure getTooltip(Object entity) {
            return null;
        }
    }

    public class TooltipFigure
    extends FlowPage {
        private final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);
        private TextFlow message;

        public TooltipFigure() {
            this.setOpaque(true);
            this.setBorder(this.TOOLTIP_BORDER);
            this.message = new TextFlow();
            this.message.setText("");
            this.add((IFigure)this.message);
        }

        public Dimension getPreferredSize(int w, int h) {
            Dimension d = super.getPreferredSize(-1, -1);
            if (d.width > 150) {
                d = super.getPreferredSize(150, -1);
            }
            return d;
        }

        public void setMessage(String txt) {
            this.message.setText(txt);
            this.revalidate();
            this.repaint();
        }
    }
}

