/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.graph;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.AnalysisServiceEvent;
import it.jrc.osint.analysis.graph.EntityEntityEdge;
import it.jrc.osint.analysis.graph.GraphEdge;
import it.jrc.osint.analysis.ui.AnalysisUIEventImpl;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.dialogs.SelectEntityTypesController;
import it.jrc.osint.analysis.ui.dialogs.SelectEntityTypesModel;
import it.jrc.osint.analysis.ui.graph.ConnectingDocumentsController;
import it.jrc.osint.analysis.ui.graph.GraphView;
import it.jrc.osint.analysis.ui.graph.GraphViewModel;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

class GraphViewController {
    private static final Logger log = LogManager.getLogger((String)GraphViewController.class.getName());
    private GraphView view;
    private ResourceId selectedProject;
    private EventBroker eb;
    private SelectEntityTypesModel selectEntityTypesModel;
    private Map<ResourceId, GraphViewModel> contentModels = new HashMap<ResourceId, GraphViewModel>();
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();

    GraphViewController(GraphView view) {
        this.view = view;
        this.eb = AnalysisUIPlugin.getEventBroker();
        this.eb.register(new String[]{"osint/analysis/datamodelChanged", "osint/analysis/entityRelationshipsCalculated"}, this.topicEventListener);
        ExtractionService es = AnalysisUIPlugin.getExtractionService();
        List availableEntityTypes = es.getEntityTypes();
        this.selectEntityTypesModel = new SelectEntityTypesModel(availableEntityTypes);
    }

    synchronized void addEntity(Entity anEntity, ResourceId projectId) {
        GraphViewModel model = this.getModel(projectId);
        model.addEntity(anEntity);
        AnalysisService as = AnalysisUIPlugin.getAnalysisService();
        HashSet existingVerticesSet = new HashSet();
        existingVerticesSet.addAll(model.getRelationshipGraph().getVertices());
        as.computeEntityEntityRelationships(projectId, existingVerticesSet, anEntity);
        this.selectedProject = projectId;
        this.view.refresh(this.getContentModel());
    }

    void setFocusedVertex(Entity vertex) {
        GraphViewModel model = this.getContentModel();
        if (model != GraphViewModel.NULL_MODEL) {
            model.setFocusedVertex(vertex);
        }
    }

    Entity getFocusedVertex() {
        GraphViewModel model = this.getContentModel();
        if (model != GraphViewModel.NULL_MODEL) {
            return model.getFocusedVertex();
        }
        return null;
    }

    GraphViewModel getContentModel() {
        if (this.selectedProject == null) {
            return GraphViewModel.NULL_MODEL;
        }
        return this.contentModels.get(this.selectedProject);
    }

    private GraphViewModel getModel(ResourceId projectId) {
        if (!this.contentModels.containsKey(projectId)) {
            GraphViewModel model = new GraphViewModel();
            this.contentModels.put(projectId, model);
        }
        return this.contentModels.get(projectId);
    }

    void remove(Entity entityVertex) {
        this.getContentModel().remove(entityVertex);
    }

    void showSelectEntityTypesDialog(Shell shell) {
        GraphViewModel model = this.getContentModel();
        if (model == GraphViewModel.NULL_MODEL) {
            return;
        }
        SelectEntityTypesController controller = new SelectEntityTypesController(this.selectEntityTypesModel.getSelectedTypes());
        int result = controller.openView(shell);
        if (result == 0) {
            SelectEntityTypesModel selectModel;
            this.selectEntityTypesModel = selectModel = controller.getModel();
            this.view.refresh(this.getContentModel());
        }
    }

    void showConnectionDialog(Shell shell, Entity sourceVertex, Entity destVertex) {
        AnalysisDatamodel ad;
        Set connectingDocs;
        Entity targetEntity;
        EntityEntityEdge eeEdge;
        Entity sourceEntity;
        ConnectingDocumentsController controller;
        int result;
        if (sourceVertex == null || destVertex == null) {
            return;
        }
        EntityEntityEdge edge = this.getGraphEdge(sourceVertex, destVertex);
        if (edge == null) {
            return;
        }
        if (edge instanceof EntityEntityEdge && (result = (controller = new ConnectingDocumentsController(sourceEntity = (eeEdge = edge).getSourceVertex(), targetEntity = eeEdge.getTargetVertex(), connectingDocs = (ad = AnalysisUIPlugin.getAnalysisService().getAnalysisDatamodel(this.selectedProject, false)).getConnectingDocuments(sourceEntity, targetEntity))).openView(shell)) == 0) {
            Set<ResourceId> selectedDocuments = controller.getSelectedDocuments();
            for (ResourceId docId : selectedDocuments) {
                this.openDocumentEditor(docId);
            }
        }
    }

    void openDocumentEditor(ResourceId docId) {
        if (docId == null) {
            return;
        }
        this.eb.postEvent((SystemEvent)new AnalysisUIEventImpl("osint/analysis/ui/openDocumentViewer", docId));
    }

    void showRelatedEntities(Entity anEntity) {
        if (anEntity == null) {
            return;
        }
        try {
            ICommandService cmdService = (ICommandService)this.view.getSite().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)this.view.getSite().getService(IHandlerService.class);
            Command addEntityCmd = cmdService.getCommand("osint.analysis.command.ShowRelatedEntities");
            IParameter entityIdParam = addEntityCmd.getParameter("entityId");
            Parameterization entityIdParameter = new Parameterization(entityIdParam, Long.toString(anEntity.getId()));
            IParameter projectIdParam = addEntityCmd.getParameter("projectId");
            Parameterization projectIdParameter = new Parameterization(projectIdParam, this.selectedProject.toString());
            ParameterizedCommand parmCommand = new ParameterizedCommand(addEntityCmd, new Parameterization[]{entityIdParameter, projectIdParameter});
            handlerService.executeCommand(parmCommand, null);
        }
        catch (Throwable t) {
            log.error("Failed to add entity to graph view", t);
        }
    }

    private EntityEntityEdge getGraphEdge(Entity sourceVertex, Entity destVertex) {
        GraphViewModel model = this.getModel(this.selectedProject);
        if (model == null || GraphViewModel.NULL_MODEL == model) {
            return null;
        }
        return (EntityEntityEdge)model.getRelationshipGraph().getEdge((Object)sourceVertex, (Object)destVertex);
    }

    int getEdgeWeight(Entity sourceVertex, Entity destVertex) {
        EntityEntityEdge edge = this.getGraphEdge(sourceVertex, destVertex);
        if (edge == null) {
            return -1;
        }
        return edge.getWeight();
    }

    void resetVisibleEntityTypes() {
        ExtractionService es = AnalysisUIPlugin.getExtractionService();
        this.selectEntityTypesModel = new SelectEntityTypesModel(es.getEntityTypes());
    }

    boolean isTypeVisible(String aType) {
        return this.selectEntityTypesModel.isSelected(aType);
    }

    private void syncContentModel(GraphViewModel graphModel, AnalysisDatamodel adm) {
        Set vertices = graphModel.getRelationshipGraph().getVertices();
        HashSet<Entity> removeVertices = new HashSet<Entity>();
        for (Entity v : vertices) {
            if (adm.getDocumentEntityRelationshipGraph().contains((Object)v)) continue;
            removeVertices.add(v);
        }
        for (Entity v : removeVertices) {
            graphModel.getRelationshipGraph().removeVertex((Object)v);
        }
    }

    void refresh() {
        if (this.selectedProject != null) {
            GraphViewModel model = this.getModel(this.selectedProject);
            AnalysisDatamodel adm = AnalysisUIPlugin.getAnalysisService().getAnalysisDatamodel(this.selectedProject, true);
            this.syncContentModel(model, adm);
            this.refreshView(model);
        }
    }

    private void refreshView(GraphViewModel graphModel) {
        this.view.refresh(graphModel);
    }

    public void clearGraph() {
        if (this.view.showConfirmationDialog("Clear graph confirmation", "Do you want to clear the graph?")) {
            this.getContentModel().clear();
            this.view.refresh(this.getContentModel());
        }
    }

    public void onDispose() {
        this.eb.unregister(this.topicEventListener);
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            try {
                ResourceId projectId;
                AnalysisServiceEvent asEvent;
                if ("osint/analysis/datamodelChanged".equals(event.getTopic())) {
                    asEvent = (AnalysisServiceEvent)event;
                    projectId = asEvent.getProjectId();
                    if (GraphViewController.this.selectedProject != null && GraphViewController.this.selectedProject.equals((Object)projectId)) {
                        AnalysisDatamodel adm = AnalysisUIPlugin.getAnalysisService().getAnalysisDatamodel(projectId, false);
                        if (adm.isNull()) {
                            if (GraphViewController.this.contentModels.containsKey(projectId)) {
                                GraphViewController.this.contentModels.remove(projectId);
                            }
                            GraphViewController.this.refreshView(new GraphViewModel());
                            return;
                        }
                        GraphViewModel model = GraphViewController.this.getModel(projectId);
                        GraphViewController.this.syncContentModel(model, adm);
                        GraphViewController.this.refreshView(model);
                    }
                }
                if ("osint/analysis/entityRelationshipsCalculated".equals(event.getTopic())) {
                    asEvent = (AnalysisServiceEvent)event;
                    projectId = asEvent.getProjectId();
                    if (GraphViewController.this.selectedProject != null && GraphViewController.this.selectedProject.equals((Object)projectId) && !asEvent.getEntityEntityEdges().isEmpty()) {
                        GraphViewModel model = GraphViewController.this.getModel(projectId);
                        Set edges = asEvent.getEntityEntityEdges();
                        for (EntityEntityEdge edge : edges) {
                            model.getRelationshipGraph().addEdge((GraphEdge)edge);
                        }
                        GraphViewController.this.refreshView(model);
                    }
                }
            }
            catch (Throwable t) {
                log.error("Error occurred in TopicEventListener#handleEvent", t);
            }
        }
    }
}

