/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.handler;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenDocumentViewerHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)OpenDocumentViewerHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorDescriptor desc;
        FileEditorInput input;
        IWorkbenchPage workbenchPage;
        block8: {
            IFile aFile;
            WorkspaceService ws;
            block7: {
                String docIdParam;
                block6: {
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                    workbenchPage = window.getActivePage();
                    try {
                        docIdParam = event.getParameter("url");
                        if (docIdParam != null) break block6;
                        log.warn("Failed to retrieve url parameter");
                        return null;
                    }
                    catch (Throwable t) {
                        log.error("Error occurred cannot open document viewer editor", t);
                        throw new ExecutionException("Error occurred", t);
                    }
                }
                ResourceId docId = new ResourceId(docIdParam);
                ws = AnalysisUIPlugin.getWorkspaceService();
                aFile = ws.getFile(docId);
                if (aFile != null && aFile.exists() && aFile.isAccessible()) break block7;
                log.error("Failed to obtain file for resource id");
                return null;
            }
            input = new FileEditorInput(aFile);
            String contentTypeId = ws.getContentTypeId(aFile.getFullPath());
            IContentTypeManager ctMgr = Platform.getContentTypeManager();
            IContentType contentType = ctMgr.getContentType(contentTypeId);
            desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(aFile.getName(), contentType);
            if (desc != null) break block8;
            log.error("Failed to obtain editor descriptor for content type: " + contentTypeId);
            return null;
        }
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = cmdService.getCommand("osint.analysis.command.ToggleReuseDocumentViewer");
        State state = cmd.getState("org.eclipse.ui.commands.toggleState");
        if (((Boolean)state.getValue()).booleanValue()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((IEditorInput)input){
                private final /* synthetic */ IEditorInput val$input;
                {
                    this.val$input = iEditorInput;
                }

                @Override
                public void run() {
                    try {
                        IEditorReference[] references;
                        IEditorReference[] iEditorReferenceArray = references = workbenchPage.getEditorReferences();
                        int n = references.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IEditorPart editorPart;
                            IEditorReference reference = iEditorReferenceArray[n2];
                            if (reference.getId().equals(desc.getId()) && (editorPart = reference.getEditor(true)) != null) {
                                editorPart.init(editorPart.getEditorSite(), this.val$input);
                                workbenchPage.activate((IWorkbenchPart)editorPart);
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable t) {
                        log.error("Failed to reuse editor", t);
                    }
                }
            });
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((IEditorInput)input, desc){
            private final /* synthetic */ IEditorInput val$input;
            private final /* synthetic */ IEditorDescriptor val$desc;
            {
                this.val$input = iEditorInput;
                this.val$desc = iEditorDescriptor;
            }

            @Override
            public void run() {
                try {
                    workbenchPage.openEditor(this.val$input, this.val$desc.getId());
                }
                catch (Throwable t) {
                    log.error("Failed to open editor", t);
                }
            }
        });
        return null;
    }

    public boolean isEnabled() {
        return true;
    }
}

