/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.AnalysisUIEvent;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class AnalysisUIService {
    private static final Logger log = LogManager.getLogger((String)AnalysisUIService.class.getName());
    private EventBroker eb;
    private TopicEventListener eventListener;

    public AnalysisUIService(EventBroker eventBroker) {
        this.eb = eventBroker;
        this.eventListener = new TopicEventListenerImpl();
        this.eb.register(new String[]{"osint/analysis/ui/openDocumentViewer", "osint/analysis/ui/addEntity"}, this.eventListener);
    }

    public void stop() {
        this.eb.unregister(this.eventListener);
    }

    private void openDocumentViewer(ResourceId docId) {
        if (docId == null || docId.isNull()) {
            return;
        }
        try {
            Command openDocView = this.getCommandService().getCommand("osint.analysis.command.OpenDocumentViewer");
            IParameter urlParam = openDocView.getParameter("url");
            Parameterization parm = new Parameterization(urlParam, docId.toString());
            ParameterizedCommand parmCommand = new ParameterizedCommand(openDocView, new Parameterization[]{parm});
            this.getHandlerService().executeCommand(parmCommand, null);
        }
        catch (Throwable t) {
            log.error("Failed to open document for id " + docId, t);
        }
    }

    private ICommandService getCommandService() {
        IWorkbench serviceLocator = PlatformUI.getWorkbench();
        ICommandService cmdService = (ICommandService)serviceLocator.getService(ICommandService.class);
        return cmdService;
    }

    private IHandlerService getHandlerService() {
        IWorkbench serviceLocator = PlatformUI.getWorkbench();
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        return handlerService;
    }

    private void openGraphViewer() {
        try {
            this.getHandlerService().executeCommand("osint.analysis.command.OpenGraphView", null);
        }
        catch (Throwable t) {
            log.error("Failed to open graph view", t);
        }
    }

    private void addEntityToGraphView(long entityId, ResourceId projectId) {
        if (0L == entityId || projectId == null || projectId.isNull()) {
            return;
        }
        try {
            Command addEntityCmd = this.getCommandService().getCommand("osint.analysis.command.AddEntity");
            IParameter entityIdParam = addEntityCmd.getParameter("entityId");
            Parameterization entityIdParameter = new Parameterization(entityIdParam, Long.toString(entityId));
            IParameter projectIdParam = addEntityCmd.getParameter("projectId");
            Parameterization projectIdParameter = new Parameterization(projectIdParam, projectId.toString());
            ParameterizedCommand parmCommand = new ParameterizedCommand(addEntityCmd, new Parameterization[]{entityIdParameter, projectIdParameter});
            this.getHandlerService().executeCommand(parmCommand, null);
        }
        catch (Throwable t) {
            log.error("Failed to add entity to graph view", t);
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            try {
                AnalysisUIEvent uiEvent;
                if ("osint/analysis/ui/openDocumentViewer".equals(event.getTopic())) {
                    uiEvent = (AnalysisUIEvent)event;
                    ResourceId docId = uiEvent.getDocumentId();
                    AnalysisUIService.this.openDocumentViewer(docId);
                }
                if ("osint/analysis/ui/addEntity".equals(event.getTopic())) {
                    uiEvent = (AnalysisUIEvent)event;
                    AnalysisUIService.this.openGraphViewer();
                    Set<Entity> entitiesToAdd = uiEvent.getEntities();
                    for (Entity anEntity : entitiesToAdd) {
                        AnalysisUIService.this.addEntityToGraphView(anEntity.getId(), uiEvent.getProjectId());
                    }
                }
            }
            catch (Throwable t) {
                log.error("Error occurred in TopicEventListener#handleEvent", t);
            }
        }
    }
}

