/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.properties;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.properties.ResourceIdPropertySourceProvider;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ResourceIdPropertySection
extends AbstractPropertySection {
    private static final Logger log = LogManager.getLogger((String)ResourceIdPropertySection.class.getName());
    protected PropertySheetPage page;

    public void createControls(Composite parent, final TabbedPropertySheetPage atabbedPropertySheetPage) {
        super.createControls(parent, atabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.page = new PropertySheetPage();
        this.page.createControl(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.page.getControl().setLayoutData((Object)data);
        this.page.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                atabbedPropertySheetPage.resizeScrolledComposite();
            }
        });
        this.page.setPropertySourceProvider((IPropertySourceProvider)new ResourceIdPropertySourceProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            TreeNode tn;
            Object valueObject;
            Object inputObject = ((IStructuredSelection)selection).getFirstElement();
            if (inputObject instanceof ResourceId) {
                super.setInput(part, selection);
                this.page.selectionChanged(part, selection);
                return;
            }
            if (inputObject instanceof TreeNode && (valueObject = (tn = (TreeNode)inputObject).getValue()) instanceof ResourceId) {
                ResourceId resourceId = (ResourceId)valueObject;
                StructuredSelection newSelection = new StructuredSelection((Object)resourceId);
                super.setInput(part, (ISelection)newSelection);
                this.page.selectionChanged(part, (ISelection)newSelection);
                return;
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    public void refresh() {
        this.page.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

