/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisPlugin;
import it.jrc.osint.analysis.AnalysisServiceEvent;
import it.jrc.osint.analysis.EntityRelationshipData;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.views.EntityBrowserModel;
import it.jrc.osint.analysis.ui.views.EntityBrowserView;
import it.jrc.osint.analysis.ui.views.EntityTreeViewerControllerImpl;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.ui.IMemento;

public class EntityBrowserController
extends EntityTreeViewerControllerImpl {
    private static final Logger log = LogManager.getLogger((String)EntityBrowserController.class.getName());
    private static final String MK_SELECTED_PROJECT_NAME = "selectedProjectName";
    private EntityBrowserView view;
    private EntityBrowserModel model;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();

    public EntityBrowserController(EntityBrowserView view) {
        super(AnalysisPlugin.getWorkspaceService(), AnalysisUIPlugin.getExtractionService(), AnalysisUIPlugin.getEventBroker());
        this.view = view;
        this.model = new EntityBrowserModel();
        this.model.signalRefreshResultTree();
    }

    void onViewCreation() {
        AnalysisUIPlugin.getEventBroker().register(new String[]{"osint/workspace/projectAdded", "osint/workspace/projectDeleted", "osint/workspace/projectMoved", "osint/workspace/metaDataChanged", "osint/workspace/serviceStarted", "osint/analysis/datamodelChanged", "osint/analysis/ui/refreshBrowserView"}, this.topicEventListener);
    }

    void selectProject(CaseProject selectedProject) {
        if (selectedProject == null) {
            return;
        }
        CaseProject currentSelectedProject = this.model.getSelectedProject();
        if (currentSelectedProject != null && currentSelectedProject.equals(selectedProject)) {
            return;
        }
        this.model.selectProject(selectedProject);
        this.model.signalRefreshResultTree();
        this.refreshView(false);
    }

    @Override
    protected AnalysisDatamodel getAnalysisDatamodel() {
        return this.model.getAnalysisDatamodel();
    }

    void performEntitySearch() {
        String searchTerm = this.view.getSearchTerm();
        EntityBrowserModel.NavigationStep searchAction = new EntityBrowserModel.NavigationStep(EntityBrowserModel.NavigationStepType.SEARCH);
        searchAction.setSearch(this.parseSearchTerm(searchTerm));
        EntityBrowserModel.NavigationStep currentAction = this.model.getSelectedProjectUserActionData().peek();
        if (!currentAction.equals(searchAction)) {
            this.model.getSelectedProjectUserActionData().push(searchAction);
            this.model.signalRefreshResultTree();
            this.refreshView(false);
        }
    }

    private String parseSearchTerm(String searchTerm) {
        String search = searchTerm.trim();
        if (search.endsWith("*")) {
            return search;
        }
        if (search.length() > 1 && search.startsWith("\"") && search.endsWith("\"")) {
            return search.substring(1, search.length() - 1);
        }
        return String.valueOf(search) + "*";
    }

    private void refreshView(boolean forceReload) {
        if (forceReload) {
            this.model.signalReloadAnalysisDatamodel();
            this.model.clearCachedViewRootNodes();
        }
        if (forceReload || this.model.hasSignalRefreshResultTree() || this.model.hasSignalRefreshProjectsList()) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EntityBrowserController.this.performRefreshView();
                }
            });
        }
    }

    private void performRefreshView() {
        TreeNode viewRootNode;
        if (this.model.hasSignalRefreshProjectsList()) {
            this.view.setSourceProjects(this.model.getSourceProjects());
            this.view.selectSourceProject(this.model.getSelectedProject());
            this.model.clearSignalRefreshProjectsList();
        }
        if (!this.model.hasSelectedProject()) {
            this.view.getEntityTreeViewer().clear();
            return;
        }
        boolean refreshResultTree = this.model.hasSignalRefreshResultTree();
        this.model.clearSignalRefreshResultTree();
        this.view.showProgressMessage("Loading Data - please wait...");
        AnalysisDatamodel ad = this.model.getAnalysisDatamodel();
        if (ad == null) {
            this.view.showProgressMessage("Please select a different source project.");
            return;
        }
        EntityBrowserModel.NavigationStep currentAction = this.model.getSelectedProjectUserActionData().peek();
        if (EntityBrowserModel.NavigationStepType.ALL_ENTITIES == currentAction.getType()) {
            this.view.setSearch("");
            this.view.getEntityTreeViewer().setOrderByMode(this.model.getOrderByMode());
            if (currentAction.getCachedViewTreeRootNode() == null || refreshResultTree) {
                Set allEntities = ad.getEntities();
                TreeNode viewRootNode2 = this.view.getEntityTreeViewer().computeEntitiesTree(allEntities, this.getVisibleEntityTypes(), (EntityRelationshipData)this.model.getAnalysisDatamodel());
                currentAction.cacheViewRootNode(viewRootNode2);
            }
            this.view.getEntityTreeViewer().setInput(currentAction.getCachedViewTreeRootNode());
            this.view.setUserActionStack(this.model.getSelectedProjectUserActionData().getUserActionStack());
        }
        if (EntityBrowserModel.NavigationStepType.RELATED_ENTITIES == currentAction.getType()) {
            this.view.getEntityTreeViewer().setOrderByMode(this.model.getOrderByMode());
            if (currentAction.getCachedViewTreeRootNode() == null || refreshResultTree) {
                Entity rootEntity = currentAction.getEntity();
                Set relatedEntities = ad.getRelatedEntities(rootEntity);
                relatedEntities.remove(rootEntity);
                viewRootNode = this.view.getEntityTreeViewer().computeRelatedEntitiesTree(rootEntity, relatedEntities, this.getVisibleEntityTypes(), (EntityRelationshipData)this.model.getAnalysisDatamodel());
                currentAction.cacheViewRootNode(viewRootNode);
            }
            this.view.setSearch("");
            this.view.getEntityTreeViewer().setInput(currentAction.getCachedViewTreeRootNode());
            this.view.setUserActionStack(this.model.getSelectedProjectUserActionData().getUserActionStack());
        }
        if (EntityBrowserModel.NavigationStepType.SEARCH == currentAction.getType()) {
            this.view.getEntityTreeViewer().setOrderByMode(this.model.getOrderByMode());
            String searchTerm = currentAction.getSearch();
            if (currentAction.getCachedViewTreeRootNode() == null || refreshResultTree) {
                Set<Entity> filteredEntities = this.filterEntities(searchTerm, ad.getEntities());
                viewRootNode = this.view.getEntityTreeViewer().computeEntitiesTree(filteredEntities, this.getVisibleEntityTypes(), (EntityRelationshipData)this.model.getAnalysisDatamodel());
                currentAction.cacheViewRootNode(viewRootNode);
            }
            this.view.setSearch(searchTerm);
            this.view.getEntityTreeViewer().setInput(currentAction.getCachedViewTreeRootNode());
            this.view.setUserActionStack(this.model.getSelectedProjectUserActionData().getUserActionStack());
        }
    }

    private Set<Entity> filterEntities(String filterTerm, Set<Entity> entities) {
        if (filterTerm == null || "".equals(filterTerm)) {
            return entities;
        }
        String filterRegex = this.createFilterRegex(filterTerm);
        RegExp r = new RegExp(filterRegex);
        Automaton a = r.toAutomaton();
        HashSet<Entity> filteredEntities = new HashSet<Entity>();
        for (Entity anEntity : entities) {
            if (!a.run(anEntity.getName())) continue;
            filteredEntities.add(anEntity);
        }
        return filteredEntities;
    }

    private String createFilterRegex(String filterTerm) {
        String regexTerm = filterTerm.replace("?", ".");
        regexTerm = regexTerm.replace("*", ".*");
        return regexTerm;
    }

    public void onPartActivated() {
        boolean forceReload = false;
        if (this.model.hasSignalRefreshProjectsList()) {
            forceReload = true;
        }
        this.refreshView(forceReload);
    }

    public void onPartClosed() {
        this.model = null;
        this.view.removeListeners();
        AnalysisUIPlugin.getEventBroker().unregister(this.topicEventListener);
    }

    public void onPartDeactivated() {
    }

    public void onPartBroughtToTop() {
    }

    public void onPartOpened() {
        List projects = this.getWorkspaceService().getCaseProjects();
        this.model.setSourceProjects(projects);
        this.model.selectInitialProject();
        this.model.signalRefreshProjectsList();
    }

    @Override
    public void showRelatedEntities(Entity anEntity) {
        EntityBrowserModel.NavigationStep ua = new EntityBrowserModel.NavigationStep(EntityBrowserModel.NavigationStepType.RELATED_ENTITIES);
        ua.setEntity(anEntity);
        this.model.getSelectedProjectUserActionData().push(ua);
        this.model.signalRefreshResultTree();
        this.refreshView(false);
    }

    public void showRelatedEntities(long entityId, ResourceId newProjectId) {
        Entity entity;
        CaseProject selectedProject = this.model.getSelectedProject();
        ResourceId selectedProjectId = selectedProject.getId();
        if (!newProjectId.equals((Object)selectedProjectId)) {
            CaseProject newProject = this.getWorkspaceService().getCaseProjectByProjectId(newProjectId);
            if (newProject == null) {
                log.error("Failed to obtain case project for project id");
                return;
            }
            this.model.selectProject(newProject);
        }
        if ((entity = this.model.getAnalysisDatamodel().getEntity(entityId)) == null) {
            log.error("Failed to obtain entity for its id");
            return;
        }
        this.showRelatedEntities(entity);
    }

    void navigateBack(EntityBrowserModel.NavigationStep selectedAction) {
        this.model.getSelectedProjectUserActionData().pop(selectedAction);
        this.model.signalRefreshResultTree();
        this.refreshView(false);
    }

    @Override
    public boolean isShowRelatedEntitiesEnabled() {
        return true;
    }

    Set<String> loadVisibleEntityTypes() {
        HashSet<String> entityTypes = new HashSet<String>();
        for (EntityType t : this.getEntityTypes()) {
            entityTypes.add(t.getId());
        }
        return entityTypes;
    }

    Set<String> getVisibleEntityTypes() {
        Set<String> visibleTypes = this.model.getVisibleEntityTypes();
        if (visibleTypes == null) {
            this.model.setVisibleEntityTypes(this.loadVisibleEntityTypes());
        }
        return this.model.getVisibleEntityTypes();
    }

    void setVisibleEntityTypes(Set<String> visibleTypes) {
        this.model.setVisibleEntityTypes(visibleTypes);
        this.refreshView(false);
    }

    public void setOrderByMode(String mode) {
        this.model.setOrderByMode(mode);
        this.refreshView(false);
    }

    public void init(IMemento memento) {
        if (memento == null) {
            return;
        }
        String selectedProjectName = memento.getString(MK_SELECTED_PROJECT_NAME);
        if (selectedProjectName != null) {
            this.model.setPreviousSessionProjectName(selectedProjectName);
        }
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        if (this.model.hasSelectedProject()) {
            memento.putString(MK_SELECTED_PROJECT_NAME, this.model.getSelectedProject().getName());
        } else {
            memento.putString(MK_SELECTED_PROJECT_NAME, null);
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if (event.getTopic() == null || "".equals(event.getTopic())) {
                return;
            }
            if ("osint/workspace/projectAdded".equals(event.getTopic())) {
                EntityBrowserController.this.model.setSourceProjects(EntityBrowserController.this.getWorkspaceService().getCaseProjects());
                EntityBrowserController.this.model.signalRefreshProjectsList();
                return;
            }
            if ("osint/workspace/projectDeleted".equals(event.getTopic())) {
                EntityBrowserController.this.model.setSourceProjects(EntityBrowserController.this.getWorkspaceService().getCaseProjects());
                WorkspaceServiceEvent wsEvent = (WorkspaceServiceEvent)event;
                ResourceId projectId = wsEvent.getProjectId();
                if (EntityBrowserController.this.model.isSelectedProject(projectId)) {
                    EntityBrowserController.this.model.selectNextAvailableProject();
                }
                EntityBrowserController.this.model.signalRefreshProjectsList();
                return;
            }
            if ("osint/workspace/projectMoved".equals(event.getTopic())) {
                EntityBrowserController.this.model.signalRefreshProjectsList();
                return;
            }
            if ("osint/workspace/metaDataChanged".equals(event.getTopic())) {
                EntityBrowserController.this.model.signalRefreshResultTree();
                return;
            }
            if ("osint/workspace/serviceStarted".equals(event.getTopic())) {
                EntityBrowserController.this.view.asyncExecInDisplayThread(new Runnable(){

                    @Override
                    public void run() {
                        EntityBrowserController.this.onPartOpened();
                    }
                });
                return;
            }
            if ("osint/analysis/datamodelChanged".equals(event.getTopic())) {
                AnalysisServiceEvent asEvent = (AnalysisServiceEvent)event;
                ResourceId projectId = asEvent.getProjectId();
                if (EntityBrowserController.this.model.isSelectedProject(projectId)) {
                    EntityBrowserController.this.model.signalReloadAnalysisDatamodel();
                    EntityBrowserController.this.model.signalRefreshResultTree();
                    EntityBrowserController.this.refreshView(true);
                }
                return;
            }
            if ("osint/analysis/ui/refreshBrowserView".equals(event.getTopic())) {
                EntityBrowserController.this.refreshView(true);
                return;
            }
        }
    }
}

