/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import com.google.common.collect.Sets;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.TreeNode;

public class EntityBrowserModel {
    private String previousSessionProjectName;
    private CaseProject selectedProject;
    private List<CaseProject> sourceProjects = Collections.emptyList();
    private Map<CaseProject, ProjectNavigationState> projectModelMap = new HashMap<CaseProject, ProjectNavigationState>();
    private boolean signalRefreshProjectsList;
    private boolean signalRefreshResultTree;
    private boolean signalReloadAnalysisDatamodel;
    private Set<String> visibleEntityTypes;
    private String orderByMode = "occurrencesCount";

    void selectProject(CaseProject selectedProject) {
        this.selectedProject = selectedProject;
        if (!this.projectModelMap.containsKey(selectedProject)) {
            this.projectModelMap.put(selectedProject, new ProjectNavigationState());
        }
    }

    CaseProject getSelectedProject() {
        return this.selectedProject;
    }

    void setPreviousSessionProjectName(String selectedProjectName) {
        this.previousSessionProjectName = selectedProjectName;
    }

    boolean hasSelectedProject() {
        return this.selectedProject != null;
    }

    ProjectNavigationState getSelectedProjectUserActionData() {
        return this.projectModelMap.get(this.selectedProject);
    }

    AnalysisDatamodel getAnalysisDatamodel() {
        if (this.selectedProject == null) {
            return null;
        }
        AnalysisService as = AnalysisUIPlugin.getAnalysisService();
        WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
        if (!ws.hasCaseProject(this.selectedProject.getId())) {
            return null;
        }
        if (this.signalReloadAnalysisDatamodel) {
            this.signalReloadAnalysisDatamodel = false;
            return as.getAnalysisDatamodel(this.selectedProject.getId(), true);
        }
        return as.getAnalysisDatamodel(this.selectedProject.getId(), false);
    }

    void signalReloadAnalysisDatamodel() {
        this.signalReloadAnalysisDatamodel = true;
    }

    void signalRefreshProjectsList() {
        this.signalRefreshProjectsList = true;
    }

    void clearSignalRefreshProjectsList() {
        this.signalRefreshProjectsList = false;
    }

    boolean hasSignalRefreshProjectsList() {
        return this.signalRefreshProjectsList;
    }

    void signalRefreshResultTree() {
        this.signalRefreshResultTree = true;
    }

    void clearSignalRefreshResultTree() {
        this.signalRefreshResultTree = false;
    }

    boolean hasSignalRefreshResultTree() {
        return this.signalRefreshResultTree;
    }

    boolean isSelectedProject(ResourceId projectId) {
        if (this.selectedProject == null) {
            return false;
        }
        return this.selectedProject.getId().equals((Object)projectId);
    }

    void setSourceProjects(List<CaseProject> projects) {
        if (projects == null) {
            return;
        }
        this.sourceProjects = projects;
        Iterator<CaseProject> pIterator = this.projectModelMap.keySet().iterator();
        while (pIterator.hasNext()) {
            CaseProject p = pIterator.next();
            if (this.sourceProjects.contains(p)) continue;
            pIterator.remove();
        }
    }

    List<CaseProject> getSourceProjects() {
        return this.sourceProjects;
    }

    void clearCachedViewRootNodes() {
        for (ProjectNavigationState p : this.projectModelMap.values()) {
            p.clearCachedViewRootNodes();
        }
    }

    Set<String> getVisibleEntityTypes() {
        return this.visibleEntityTypes;
    }

    void setVisibleEntityTypes(Set<String> visibleTypes) {
        if (this.visibleEntityTypes == null) {
            this.visibleEntityTypes = visibleTypes;
        } else {
            Sets.SetView diff = Sets.symmetricDifference(this.visibleEntityTypes, visibleTypes);
            if (!diff.isEmpty()) {
                this.visibleEntityTypes = visibleTypes;
                this.signalRefreshResultTree = true;
            }
        }
    }

    public void setOrderByMode(String newMode) {
        if (!this.orderByMode.equals(newMode)) {
            this.orderByMode = newMode;
            this.signalRefreshResultTree = true;
        }
    }

    public String getOrderByMode() {
        return this.orderByMode;
    }

    public void selectInitialProject() {
        if (this.sourceProjects.isEmpty()) {
            return;
        }
        CaseProject selectedProject = null;
        if (this.previousSessionProjectName != null) {
            selectedProject = this.findProject(this.previousSessionProjectName, this.sourceProjects);
        }
        if (selectedProject == null) {
            selectedProject = this.sourceProjects.get(0);
        }
        this.selectProject(selectedProject);
    }

    public void selectNextAvailableProject() {
        if (this.sourceProjects.isEmpty()) {
            this.selectedProject = null;
            return;
        }
        this.selectProject(this.sourceProjects.get(0));
    }

    private CaseProject findProject(String projectName, List<CaseProject> caseProjects) {
        for (CaseProject cp : caseProjects) {
            if (!projectName.equals(cp.getName())) continue;
            return cp;
        }
        return null;
    }

    static class NavigationStep {
        private NavigationStepType type;
        private Entity entity;
        private String search;
        private TreeNode cachedViewRootNode;

        public NavigationStep(NavigationStepType type) {
            this.type = type;
        }

        public NavigationStepType getType() {
            return this.type;
        }

        public void setEntity(Entity anEntity) {
            this.entity = anEntity;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String getSearch() {
            return this.search;
        }

        public void cacheViewRootNode(TreeNode rootNode) {
            this.cachedViewRootNode = rootNode;
        }

        public TreeNode getCachedViewTreeRootNode() {
            return this.cachedViewRootNode;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof NavigationStep) {
                NavigationStep otherAction = (NavigationStep)other;
                return otherAction.toString().equals(this.toString());
            }
            return false;
        }

        public String toString() {
            if (this.type == NavigationStepType.ALL_ENTITIES) {
                return "All entities of project";
            }
            if (this.type == NavigationStepType.SEARCH) {
                return "Entities matching " + this.search;
            }
            if (this.type == NavigationStepType.RELATED_ENTITIES) {
                return "Entities related to \"" + this.entity.getName() + "\"";
            }
            return "invalid type";
        }

        public void clearCachedViewRootNode() {
            this.cachedViewRootNode = null;
        }
    }

    static enum NavigationStepType {
        ALL_ENTITIES,
        RELATED_ENTITIES,
        SEARCH;

    }

    static class ProjectNavigationState {
        private List<NavigationStep> navigationActionStack = new ArrayList<NavigationStep>();

        ProjectNavigationState() {
        }

        public List<NavigationStep> getUserActionStack() {
            if (this.navigationActionStack.isEmpty()) {
                this.navigationActionStack.add(new NavigationStep(NavigationStepType.ALL_ENTITIES));
            }
            return this.navigationActionStack;
        }

        public void clearEntityStack() {
            this.navigationActionStack.clear();
        }

        public void clearCachedViewRootNodes() {
            for (NavigationStep ua : this.navigationActionStack) {
                ua.clearCachedViewRootNode();
            }
        }

        public void push(NavigationStep userAction) {
            this.getUserActionStack().add(0, userAction);
        }

        public NavigationStep peek() {
            return this.getUserActionStack().get(0);
        }

        public NavigationStep pop() {
            if (this.navigationActionStack.size() > 1) {
                return this.getUserActionStack().remove(0);
            }
            return null;
        }

        public void pop(NavigationStep selectedAction) {
            Iterator<NavigationStep> uaIterator = this.navigationActionStack.iterator();
            while (uaIterator.hasNext()) {
                NavigationStep ua = uaIterator.next();
                if (!ua.equals(selectedAction)) {
                    uaIterator.remove();
                    continue;
                }
                return;
            }
        }
    }
}

