/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisPlugin;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.EntityContainer;
import it.jrc.osint.analysis.EntityContainerChangeListener;
import it.jrc.osint.analysis.EntityRelationshipData;
import it.jrc.osint.analysis.ui.AnalysisUIEventImpl;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.views.EntityTreeViewer;
import it.jrc.osint.analysis.ui.views.EntityTreeViewerControllerImpl;
import it.jrc.osint.analysis.ui.views.RelatedEntitiesView;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEvent;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.TreeNode;

public class RelatedEntitiesViewController
extends EntityTreeViewerControllerImpl {
    private static final Logger log = LogManager.getLogger((String)RelatedEntitiesViewController.class.getName());
    private RelatedEntitiesView view;
    private EntityContainer entityContainer;
    private Set<Entity> entitySet = new HashSet<Entity>();
    private EntityContainerChangeListener entitySetChangeListener = new EntitySetChangeListenerImpl();
    private Set<String> visibleEntityTypes = new HashSet<String>();

    public RelatedEntitiesViewController(RelatedEntitiesView view) {
        super(AnalysisUIPlugin.getWorkspaceService(), AnalysisUIPlugin.getExtractionService(), AnalysisUIPlugin.getEventBroker());
        this.view = view;
        for (EntityType t : this.getEntityTypes()) {
            this.visibleEntityTypes.add(t.getId());
        }
    }

    @Override
    protected AnalysisDatamodel getAnalysisDatamodel() {
        if (this.entityContainer != null) {
            AnalysisService as = AnalysisPlugin.getAnalysisService();
            return as.getAnalysisDatamodel(this.entityContainer.getProjectId(), false);
        }
        return null;
    }

    boolean isCurrentContainer(EntityContainer aContainer) {
        return this.entityContainer == aContainer;
    }

    void onRefreshData(EntityContainer esProvider) {
        if (esProvider == null) {
            return;
        }
        if (this.entityContainer == esProvider) {
            return;
        }
        if (this.entityContainer != esProvider) {
            if (this.entityContainer != null) {
                this.entityContainer.removeChangeListener(this.entitySetChangeListener);
            }
            esProvider.addChangeListener(this.entitySetChangeListener);
        }
        this.entityContainer = esProvider;
        this.entitySet.clear();
        this.entitySet.addAll(esProvider.getEntities());
        this.refreshView();
    }

    void onClearData() {
        TreeNode viewRootNode = new TreeNode((Object)"Entities");
        if (this.view == null) {
            return;
        }
        EntityTreeViewer treeViewer = this.view.getEntityTreeViewer();
        if (treeViewer != null) {
            treeViewer.setInput(viewRootNode);
        }
    }

    private void refreshView() {
        if (this.view == null) {
            return;
        }
        if (this.view.getEntityTreeViewer() != null) {
            TreeNode viewRootNode = this.view.getEntityTreeViewer().computeEntitiesTree(this.entitySet, this.visibleEntityTypes, (EntityRelationshipData)this.getAnalysisDatamodel());
            this.view.getEntityTreeViewer().setInput(viewRootNode);
        }
    }

    void onViewClosed() {
        if (this.entityContainer != null) {
            this.entityContainer.removeChangeListener(this.entitySetChangeListener);
        }
        this.view = null;
    }

    void showEntityTextLocations(Entity anEntity) {
        AnalysisUIPlugin.getEventBroker().postEvent((SystemEvent)new AnalysisUIEventImpl("osint/analysis/ui/showEntityMarkup", anEntity, this.getAnalysisDatamodel().getProjectId()));
    }

    void resetTextMarkup() {
        AnalysisUIPlugin.getEventBroker().postEvent((SystemEvent)new AnalysisUIEventImpl("osint/analysis/ui/resetEntityMarkup"));
    }

    private class EntitySetChangeListenerImpl
    implements EntityContainerChangeListener {
        private EntitySetChangeListenerImpl() {
        }

        public void entitiesChanged() {
            RelatedEntitiesViewController.this.onRefreshData(RelatedEntitiesViewController.this.entityContainer);
        }
    }
}

