/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui;

import it.jrc.osint.grabber.GrabberPlugin;
import it.jrc.osint.grabber.GrabberService;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.internal.SearchUIService;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.io.File;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SearchUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "it.jrc.osint.search.ui";
    private static SearchUIPlugin plugin;
    private static final Logger log;
    private EventBroker eventBroker;
    private SearchUIService uiService;

    static {
        log = LogManager.getLogger((String)SearchUIPlugin.class.getName());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.eventBroker = new EventBroker(context);
        this.uiService = new SearchUIService(this.eventBroker);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.uiService != null) {
            this.uiService.stop();
        }
        super.stop(context);
        this.eventBroker.stop();
        plugin = null;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("default_google.ico", SearchUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/favicon/google.ico"));
        reg.put("default_bing.ico", SearchUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/favicon/bing.ico"));
        reg.put("default_yahoo.ico", SearchUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/favicon/yahoo.ico"));
        reg.put("default_blekko.ico", SearchUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/favicon/blekko.ico"));
        reg.put("default_generic.ico", SearchUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/favicon/generic.gif"));
        reg.put("folder", SearchUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/eclipse.ui/icons/full/obj16/fldr_obj.gif"));
        File favIconDir = this.getFavIconDir();
        File[] iconFiles = favIconDir.listFiles();
        if (iconFiles != null) {
            File[] fileArray = iconFiles;
            int n = iconFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File iconFile = fileArray[n2];
                if (iconFile.exists()) {
                    try {
                        ImageDescriptor id = ImageDescriptor.createFromURL((URL)iconFile.toURI().toURL());
                        reg.put(iconFile.getName(), id);
                    }
                    catch (Throwable t) {
                        log.error("Failed to create image descriptor for file", t);
                    }
                }
                ++n2;
            }
        }
    }

    private synchronized File getFavIconDir() {
        File pluginStateDir = this.getStateLocation().toFile();
        File favIconDir = new File(pluginStateDir, "icons");
        if (!favIconDir.exists()) {
            favIconDir.mkdir();
        }
        return favIconDir;
    }

    public static SearchUIPlugin getPlugin() {
        return plugin;
    }

    public EventBroker getEventBroker() {
        return SearchUIPlugin.getPlugin().eventBroker;
    }

    public static SearchService getSearchService() {
        return SearchPlugin.getSearchService();
    }

    private static GrabberService getGrabberService() {
        return GrabberPlugin.getGrabberService();
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    public Image getFavIcon(String name, String url) {
        String iconKey = String.valueOf(name.toLowerCase()) + ".ico";
        ImageRegistry ir = this.getImageRegistry();
        Image anImage = ir.get(iconKey);
        if (anImage == null) {
            File favIconFile = new File(this.getFavIconDir(), iconKey);
            if (SearchUIPlugin.getGrabberService().grabImage(url, favIconFile)) {
                try {
                    ImageDescriptor id = ImageDescriptor.createFromURL((URL)favIconFile.toURI().toURL());
                    ir.put(iconKey, id);
                }
                catch (Throwable t) {
                    log.error("Failed to create image descriptor for file", t);
                }
            } else {
                String defaultIconKey = "default_" + iconKey;
                ImageDescriptor id = ir.getDescriptor(defaultIconKey);
                if (id != null) {
                    ir.put(iconKey, id);
                } else {
                    id = ir.getDescriptor("default_generic.ico");
                    ir.put(iconKey, id);
                }
            }
        }
        if ((anImage = ir.get(iconKey)) != null) {
            if (anImage.getBounds().width > 16) {
                Image scaledIcon = new Image((Device)Display.getDefault(), anImage.getImageData().scaledTo(16, 16));
                ir.remove(iconKey);
                ir.put(iconKey, scaledIcon);
            }
            return ir.get(iconKey);
        }
        return null;
    }
}

