/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.handlers;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.ui.browser.BrowserContainer;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.util.ui.dialog.SaveAsDialog;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreateBookmarkHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)CreateBookmarkHandler.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        if (window == null) {
            return null;
        }
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (!(activeEditor instanceof IAdaptable)) {
            return null;
        }
        BrowserContainer searchBrowser = (BrowserContainer)activeEditor.getAdapter(BrowserContainer.class);
        if (searchBrowser == null) {
            return null;
        }
        WorkspaceService ws = SearchUIPlugin.getWorkspaceService();
        List projects = ws.getCaseProjects();
        if (projects.isEmpty()) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Create Case Project", (String)"Please create a case project first");
            return null;
        }
        if (searchBrowser != null) {
            InputStream in = null;
            try {
                try {
                    String title = searchBrowser.getTitle();
                    String url = searchBrowser.getBrowser().getUrl();
                    SearchService searchSvc = SearchPlugin.getSearchService();
                    URLBookmark bookmark = searchSvc.createBookmark(url);
                    bookmark.setTitle(title);
                    if (title == null || "".equals(title)) {
                        title = "aBookmark";
                    }
                    String fileName = String.valueOf(title) + "." + "obm";
                    SaveAsDialog dialog = new SaveAsDialog(window.getShell(), (AbstractUIPlugin)SearchUIPlugin.getPlugin());
                    dialog.setOriginalName(fileName);
                    int dialogResult = dialog.open();
                    if (dialogResult != 0) return null;
                    IPath filePath = dialog.getResult();
                    in = searchSvc.saveBookmark(bookmark);
                    boolean overwrite = true;
                    if (ws.exists(filePath)) {
                        overwrite = MessageDialog.openQuestion((Shell)window.getShell(), (String)"File exists", (String)"Do you want to overwrite existing file?");
                    }
                    if (!overwrite) return null;
                    IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                    String projectName = filePath.segment(0);
                    CaseProject cp = ws.getCaseProjectByName(projectName);
                    cp.addFile(newFile, in, true, null);
                    return null;
                }
                catch (Throwable t) {
                    log.error("Failed to create url bookmark", t);
                    FileUtil.close(in);
                }
                return null;
            }
            finally {
                FileUtil.close(in);
            }
        } else {
            log.error("Could not adapt editor to browser");
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }
}

