/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.internal;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class SearchUIService {
    private static final Logger log = LogManager.getLogger((String)SearchUIService.class.getName());
    private EventBroker eb;
    private TopicEventListener eventListener;

    public SearchUIService(EventBroker eb) {
        this.eb = eb;
        this.eventListener = new TopicEventListenerImpl();
        this.eb.register(new String[]{"osint/search/urlChanged"}, this.eventListener);
    }

    public void stop() {
        this.eb.unregister(this.eventListener);
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            try {
                if ("osint/search/urlChanged".equals(event.getTopic())) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
                            evaluationService.requestEvaluation("it.jrc.osint.ui.canExtractCurrentURL");
                        }
                    });
                }
            }
            catch (Throwable t) {
                log.error("Error occurred in TopicEventListener#handleEvent", t);
            }
        }
    }
}

