/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.navigator;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class BookmarkDescriptionProvider
extends LabelProviderAdapter
implements IDescriptionProvider {
    private static final Logger log = LogManager.getLogger((String)BookmarkDescriptionProvider.class.getName());

    public String getDescription(Object anElement) {
        if (anElement instanceof IFile && this.getSearchService().isBookmark((IFile)anElement)) {
            String string;
            IFile bookmarkFile = (IFile)anElement;
            InputStream in = null;
            try {
                SearchService ss = SearchUIPlugin.getSearchService();
                in = bookmarkFile.getContents();
                URLBookmark bookmark = ss.loadBookmark(in);
                string = bookmark.getURL();
            }
            catch (Throwable t) {
                try {
                    log.error("Failed to load bookmark file", t);
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
                FileUtil.close((InputStream)in);
            }
            FileUtil.close((InputStream)in);
            return string;
        }
        return null;
    }

    private SearchService getSearchService() {
        return SearchUIPlugin.getSearchService();
    }
}

