/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.properties;

import it.jrc.osint.ResourceId;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class URLBookmarkPropertySource
implements IPropertySource {
    private URLBookmark bookmark;
    private ResourceId id;

    public URLBookmarkPropertySource(URLBookmark bm) {
        this.bookmark = bm;
    }

    public URLBookmarkPropertySource(URLBookmark bm, ResourceId id) {
        this(bm);
        this.id = id;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> properties = new ArrayList<TextPropertyDescriptor>();
        properties.add(new TextPropertyDescriptor((Object)"url", "URL"));
        properties.add(new TextPropertyDescriptor((Object)"title", "Title"));
        if (this.bookmark.getDescription() != null && !"".equals(this.bookmark.getDescription())) {
            properties.add(new TextPropertyDescriptor((Object)"desc", "Description"));
        }
        properties.add(new TextPropertyDescriptor((Object)"searchEngine", "Search Engine"));
        properties.add(new TextPropertyDescriptor((Object)"searchQuery", "Search Query"));
        properties.add(new TextPropertyDescriptor((Object)"timestamp", "Timestamp"));
        SearchService ss = SearchUIPlugin.getSearchService();
        if (ss.isDuplicateBookmark(this.id)) {
            properties.add(new TextPropertyDescriptor((Object)"duplicateOf", "Duplicate of file"));
        }
        return properties.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        SearchService ss;
        IPath originalFilePath;
        if (id.equals("url")) {
            return this.bookmark.getURL();
        }
        if (id.equals("title")) {
            return this.bookmark.getTitle();
        }
        if (id.equals("desc")) {
            return this.bookmark.getDescription();
        }
        if (id.equals("searchEngine")) {
            return this.bookmark.getSearchEngine();
        }
        if (id.equals("searchQuery")) {
            return this.bookmark.getSearchQuery();
        }
        if (id.equals("timestamp")) {
            Date aDate = this.bookmark.getCreationTimestamp();
            if (aDate == null) {
                return "--";
            }
            return DateUtil.getFormattedTimestamp((Date)aDate);
        }
        if (id.equals("duplicateOf") && (originalFilePath = (ss = SearchUIPlugin.getSearchService()).getOriginalOfDuplicateBookmark(this.id)) != null) {
            return originalFilePath.toString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

