/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.properties;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.search.ui.properties.URLBookmarkPropertySource;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class URLBookmarkPropertySourceProvider
implements IPropertySourceProvider {
    private static final Logger log = LogManager.getLogger((String)URLBookmarkPropertySourceProvider.class.getName());

    public IPropertySource getPropertySource(Object object) {
        if (object instanceof IFile) {
            IFile bookmarkFile = (IFile)object;
            URLBookmark bookmark = this.loadBookmark(bookmarkFile);
            WorkspaceService ws = SearchUIPlugin.getWorkspaceService();
            ResourceId id = ws.getId(bookmarkFile.getFullPath());
            if (bookmark != null) {
                return new URLBookmarkPropertySource(bookmark, id);
            }
        }
        return null;
    }

    private URLBookmark loadBookmark(IFile aFile) {
        try {
            SearchService ss = SearchUIPlugin.getSearchService();
            URLBookmark bookmark = ss.loadBookmark(aFile.getContents());
            return bookmark;
        }
        catch (Throwable t) {
            log.error("Failed to load bookmark from file: " + aFile.getFullPath());
            return null;
        }
    }
}

