/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationResult;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPageController;
import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPageController;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspacePlugin;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class TSVBookmarkImportWizard
extends Wizard
implements IImportWizard {
    private static final Logger log = LogManager.getLogger((String)TSVBookmarkImportWizard.class.getName());
    private IStructuredSelection selection;
    private SelectFileWizardPageController selectFileController;
    private SelectProjectFolderWizardPageController selectFolderController;

    public void addPages() {
        super.addPages();
        this.selectFileController = new SelectFileWizardPageController();
        this.selectFileController.setPageTitle("Select file for import");
        this.selectFileController.setPageDescription("Select Firefox or IE bookmarks file");
        this.addPage(this.selectFileController.getView());
        this.selectFolderController = new SelectProjectFolderWizardPageController();
        this.selectFolderController.setFolder(this.getFolderFromSelection());
        this.selectFolderController.setPageTitle("Folder to import");
        this.selectFolderController.setPageDescription("Select folder to store imported bookmarks");
        this.selectFolderController.setPageFolderInputLabel("Select folder");
        this.addPage(this.selectFolderController.getView());
    }

    private IFolder getFolderFromSelection() {
        Object element;
        IFolder result = null;
        if (this.selection != null && (element = this.selection.getFirstElement()) instanceof IFolder) {
            return (IFolder)element;
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        List importedBookmarks;
        SearchService ss;
        OperationResult result;
        if (this.selectFileController.hasFilePath() && this.selectFolderController.hasFolder() && (result = (ss = SearchUIPlugin.getSearchService()).getImporter().importBookmarksFromTSVFile(this.selectFileController.getFilePath())).isOk() && (importedBookmarks = (List)result.getResult()) != null && !importedBookmarks.isEmpty()) {
            IFolder importFolder = this.selectFolderController.getFolder();
            String importProjectName = importFolder.getProject().getName();
            CaseProject importProject = WorkspacePlugin.getWorkspaceService().getCaseProjectByName(importProjectName);
            ss.getImporter().importBookmarks(this.selectFolderController.getFolder().getName(), importProject, importedBookmarks);
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        return false;
    }
}

