/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.wizard;

import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPageController;
import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPageController;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class XmlDocumentsExportWizardFile
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private SelectFileWizardPageController selectFileController;
    private SelectProjectFolderWizardPageController selectFolderController;

    public void addPages() {
        super.addPages();
        this.selectFolderController = new SelectProjectFolderWizardPageController();
        this.selectFolderController.setFolder(this.getFolderFromSelection());
        this.selectFolderController.setPageTitle("Folder to export");
        this.selectFolderController.setPageDescription("Select folder containing documents to export.\nIMPORTANT: This folder must be under the 'Documents' folder.");
        this.selectFolderController.setPageFolderInputLabel("Select folder");
        this.addPage(this.selectFolderController.getView());
        this.selectFileController = new SelectFileWizardPageController();
        this.selectFileController.setPageTitle("Export File Selection");
        this.selectFileController.setPageDescription("Select the XML file to export to");
        this.selectFileController.setSaveDialog(true);
        this.addPage(this.selectFileController.getView());
    }

    private IFolder getFolderFromSelection() {
        Object element;
        IFolder result = null;
        if (this.selection != null && (element = this.selection.getFirstElement()) instanceof IFolder) {
            return (IFolder)element;
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        if (this.selectFileController.hasFilePath() && this.selectFolderController.hasFolder()) {
            SearchService ss = SearchUIPlugin.getSearchService();
            OperationStatus result = ss.getExporter().exportDocumentsToXMLFile(this.selectFolderController.getFolder(), this.selectFileController.getFilePath());
            return result == OperationStatus.OK_STATUS || result == OperationStatus.CANCEL_STATUS;
        }
        return false;
    }
}

