/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.index.ui.views;

import it.jrc.osint.ResourceId;
import it.jrc.osint.index.ui.IndexUIPlugin;
import it.jrc.osint.index.ui.views.DocForTreeViewer;
import it.jrc.osint.index.ui.views.IndexSearchUIController;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class IndexSearchUIView
extends ViewPart {
    public static final String ID = "it.jrc.osint.index.ui.views.IndexSearchView";
    private static final Logger log = LogManager.getLogger((String)IndexUIPlugin.class.getName());
    private IndexSearchUIController controller = new IndexSearchUIController(this);
    private Composite srtitlecomposite;
    private Composite resultLocalSearchComposite;
    private Text querySearchText;
    private Button querySearchButton;
    private Label resultsLabel;
    private TreeViewer resultTreeViewer;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite(container, 0);
        searchComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        searchComposite.setLayout((Layout)new GridLayout(4, false));
        Label searchQueryLabel = new Label(searchComposite, 0);
        GridData gd_searchQueryLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_searchQueryLabel.horizontalIndent = 5;
        searchQueryLabel.setLayoutData((Object)gd_searchQueryLabel);
        searchQueryLabel.setText("Search query:");
        this.querySearchText = new Text(searchComposite, 2048);
        GridData gd_searchQueryText = new GridData(16384, 16384, false, false, 2, 1);
        gd_searchQueryText.widthHint = 200;
        gd_searchQueryText.heightHint = 20;
        this.querySearchText.setLayoutData((Object)gd_searchQueryText);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                IndexSearchUIView.this.srtitlecomposite.layout();
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.querySearchText.addFocusListener(focusListener);
        this.querySearchText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    IndexSearchUIView.this.controller.performLocalSearch(IndexSearchUIView.this.querySearchText.getText());
                    IndexSearchUIView.this.srtitlecomposite.layout();
                    IndexSearchUIView.this.resultTreeViewer.expandAll();
                }
            }
        });
        this.querySearchButton = new Button(searchComposite, 0);
        this.querySearchButton.setText("Search");
        this.querySearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexSearchUIView.this.controller.performLocalSearch(IndexSearchUIView.this.querySearchText.getText());
                IndexSearchUIView.this.srtitlecomposite.layout();
                IndexSearchUIView.this.resultTreeViewer.expandAll();
            }
        });
        this.resultLocalSearchComposite = new Composite(container, 2048);
        this.resultLocalSearchComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.resultLocalSearchComposite.setLayout((Layout)new GridLayout(1, false));
        this.srtitlecomposite = new Composite(this.resultLocalSearchComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.srtitlecomposite.setLayout((Layout)gridLayout);
        this.srtitlecomposite.setLayoutData((Object)gridData);
        Label searchresultsLabel = new Label(this.srtitlecomposite, 0);
        Font initialFont = searchresultsLabel.getFont();
        Device device = initialFont.getDevice();
        FontData[] fontData = initialFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(1);
            ++i;
        }
        Font newFont = new Font(device, fontData);
        searchresultsLabel.setFont(newFont);
        searchresultsLabel.setText("Search results:  ");
        this.resultsLabel = new Label(this.srtitlecomposite, 0);
        this.resultsLabel.setText("");
        Composite resultTreeComposite = new Composite(this.resultLocalSearchComposite, 0);
        GridData gd_resultTreeComposite = new GridData(4, 4, true, true, 1, 1);
        gd_resultTreeComposite.horizontalIndent = 3;
        resultTreeComposite.setLayoutData((Object)gd_resultTreeComposite);
        resultTreeComposite.setLayout((Layout)new FillLayout(256));
        this.resultTreeViewer = new TreeViewer(resultTreeComposite, 4);
        this.resultTreeViewer.setLabelProvider((IBaseLabelProvider)new DocumentTreeLabelProvider());
        this.resultTreeViewer.setContentProvider((IContentProvider)new DocumentTreeContentProvider());
        this.resultTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    DocForTreeViewer doc = (DocForTreeViewer)selection.getFirstElement();
                    if (doc.isDocument()) {
                        IndexSearchUIView.this.controller.openDocument(new ResourceId(doc.getResourceId()), IndexSearchUIView.this.getSite());
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to open document view", t);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.resultTreeViewer);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    private void createActions() {
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
    }

    public void setFocus() {
    }

    public Label getSearchResultLabel() {
        return this.resultsLabel;
    }

    public TreeViewer getIndexSearchTreeViewer() {
        return this.resultTreeViewer;
    }

    public void cleanSearchResultLabel() {
        this.getSearchResultLabel().setText("");
        this.srtitlecomposite.layout();
    }

    public void setSearchResults(final DocForTreeViewer[] dataset) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IndexSearchUIView.this.getSearchResultLabel().setText(String.valueOf(IndexSearchUIView.this.controller.getNumberDocumentsRetrieved(dataset)) + " documents found");
                    IndexSearchUIView.this.getIndexSearchTreeViewer().setInput((Object)dataset);
                    IndexSearchUIView.this.getIndexSearchTreeViewer().refresh();
                    IndexSearchUIView.this.srtitlecomposite.layout();
                }
                catch (Throwable t) {
                    log.error("Failed to show the search results", t);
                }
            }
        });
    }

    public void showProgressMessage(final String msg) {
        if (this.resultTreeViewer == null) {
            return;
        }
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DocForTreeViewer[] temp = new DocForTreeViewer[]{new DocForTreeViewer(msg, "", "message")};
                    IndexSearchUIView.this.getIndexSearchTreeViewer().setInput((Object)temp);
                    IndexSearchUIView.this.getIndexSearchTreeViewer().refresh();
                }
                catch (Throwable t) {
                    log.error("Failed to show message to TreeViewer", t);
                }
            }
        });
    }

    public void disableSearch() {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IndexSearchUIView.this.querySearchText.setEnabled(false);
                    IndexSearchUIView.this.querySearchButton.setEnabled(false);
                    IndexSearchUIView.this.srtitlecomposite.layout();
                }
                catch (Throwable t) {
                    log.error("Failed to disable the search", t);
                }
            }
        });
    }

    public void enableSearch() {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IndexSearchUIView.this.querySearchText.setEnabled(true);
                    IndexSearchUIView.this.querySearchButton.setEnabled(true);
                    IndexSearchUIView.this.srtitlecomposite.layout();
                }
                catch (Throwable t) {
                    log.error("Failed to enable the search", t);
                }
            }
        });
    }

    private class DocumentTreeContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private DocumentTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            DocForTreeViewer docu = (DocForTreeViewer)parentElement;
            return docu.children;
        }

        public Object getParent(Object element) {
            DocForTreeViewer document = (DocForTreeViewer)element;
            return document.parent;
        }

        public boolean hasChildren(Object element) {
            DocForTreeViewer docu = (DocForTreeViewer)element;
            return docu.children.length > 0;
        }
    }

    private class DocumentTreeLabelProvider
    extends LabelProvider {
        private DocumentTreeLabelProvider() {
        }

        public String getText(Object element) {
            DocForTreeViewer docu = (DocForTreeViewer)element;
            return docu.getLabel();
        }

        public Image getImage(Object element) {
            DocForTreeViewer docu = (DocForTreeViewer)element;
            if (docu.getDocType().equals("message")) {
                return null;
            }
            if (docu.children.length == 0) {
                if (docu.getDocType().equals("html")) {
                    return IndexUIPlugin.getPlugin().getImageRegistry().get("html_document");
                }
                if (docu.getDocType().equals("txt")) {
                    return IndexUIPlugin.getPlugin().getImageRegistry().get("txt_document");
                }
                if (docu.getDocType().equals("pdf")) {
                    return IndexUIPlugin.getPlugin().getImageRegistry().get("pdf_document");
                }
                if (docu.getDocType().equals("doc")) {
                    return IndexUIPlugin.getPlugin().getImageRegistry().get("word_document");
                }
                if (docu.getDocType().equals("ptx")) {
                    return IndexUIPlugin.getPlugin().getImageRegistry().get("powerpoint_document");
                }
                if (docu.getDocType().equals("xls")) {
                    return IndexUIPlugin.getPlugin().getImageRegistry().get("excel_document");
                }
                return IndexUIPlugin.getPlugin().getImageRegistry().get("html_document");
            }
            return IndexUIPlugin.getPlugin().getImageRegistry().get("folder");
        }
    }
}

